/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.currency;

import com.robertx22.mine_and_slash.database.items.currency.CurrencyItem;
import com.robertx22.mine_and_slash.database.items.currency.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.IRenamed;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ItemLevelUpGear
extends CurrencyItem
implements ICurrencyItemEffect,
IRenamed {
    private static final String name = "mmorpg:currency/item_levelup";
    public static final int MAXIMUM_LEVEL_UPS = 10;

    @Override
    public String GUID() {
        return "currency/item_levelup";
    }

    @Override
    public List<String> oldNames() {
        return Arrays.asList("mmorpg:item_levelup");
    }

    public ItemLevelUpGear() {
        super(name);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        gear.setLevel(gear.level + 1);
        ++gear.timesLeveledUp;
        Gear.Save(stack, gear);
        return stack;
    }

    @Override
    public int getRarityRank() {
        return 3;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(SimpleGearLocReq.LVLED_LESS_THAN_10_TIMES, SimpleGearLocReq.LEVEL_ISNT_HIGHER_THAN_MAX);
    }

    @Override
    public int Tier() {
        return 5;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Who said your sword can't level with you?");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Crystal Of Ascension";
    }

    @Override
    public String locDescForLangFile() {
        return "Increases item level";
    }

    @Override
    public int instabilityAddAmount() {
        return 5;
    }
}

