/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.currency;

import com.robertx22.mine_and_slash.database.items.currency.CurrencyItem;
import com.robertx22.mine_and_slash.database.items.currency.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.IHasRecipe;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.gens.GearLootGen;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.professions.recipe.SimpleRecipe;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.IRenamed;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public class ItemOrbOfTransmutation
extends CurrencyItem
implements ICurrencyItemEffect,
IRenamed,
IHasRecipe {
    public static final String ID = "mmorpg:currency/orb_of_transmutation";

    @Override
    public String GUID() {
        return "currency/orb_of_transmutation";
    }

    @Override
    public List<String> oldNames() {
        return Arrays.asList("mmorpg:orb_of_transmutation");
    }

    public ItemOrbOfTransmutation() {
        super(ID);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        GearBlueprint gearPrint = new GearBlueprint(gear.level);
        gearPrint.SetSpecificType(gear.gearTypeName);
        gearPrint.minRarity = 1;
        gearPrint.LevelRange = false;
        GearItemData newgear = GearLootGen.CreateData(gearPrint);
        gear.WriteOverDataThatShouldStay(newgear);
        ItemStack result = ItemStack.field_190927_a;
        if (gear.changesItemStack()) {
            result = GearLootGen.CreateStack(newgear);
        } else {
            result = stack;
            Gear.Save(result, newgear);
        }
        return result;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(SimpleGearLocReq.IS_COMMON);
    }

    @Override
    public int Tier() {
        return 0;
    }

    @Override
    public int getRarityRank() {
        return 0;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Turn trash into treasure!");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Orb Of Transmutation";
    }

    @Override
    public String locDescForLangFile() {
        return "Transform Common Item";
    }

    @Override
    public int instabilityAddAmount() {
        return 0;
    }

    @Override
    public BaseRecipe getRecipe() {
        return SimpleRecipe.Builder.create(this.GUID(), Professions.TINKERERING).addMaterial(ItemOre.ItemOres.get(this.getRarityRank()), 2).addMaterial(Items.field_151043_k, 1).addMaterial(Items.field_151044_h, 2).addMaterial(Items.field_151137_ax, 3).buildMaterials().setOutput(this).levelReq(1).expGained(25).build();
    }
}

