/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.currency;

import com.robertx22.mine_and_slash.database.items.currency.CurrencyItem;
import com.robertx22.mine_and_slash.database.items.currency.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.gens.GearLootGen;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.IRenamed;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ItemStoneOfHope
extends CurrencyItem
implements ICurrencyItemEffect,
IRenamed {
    public static final String ID = "mmorpg:currency/stone_of_hope";

    @Override
    public String GUID() {
        return "currency/stone_of_hope";
    }

    @Override
    public List<String> oldNames() {
        return Arrays.asList("mmorpg:stone_of_hope");
    }

    public ItemStoneOfHope() {
        super(ID);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        GearBlueprint gearPrint = new GearBlueprint(gear.level);
        gearPrint.SetSpecificType(gear.gearTypeName);
        gearPrint.minRarity = gear.Rarity + 1;
        gearPrint.LevelRange = false;
        GearItemData newgear = GearLootGen.CreateData(gearPrint);
        gear.WriteOverDataThatShouldStay(newgear);
        ItemStack result = ItemStack.field_190927_a;
        if (gear.changesItemStack()) {
            result = GearLootGen.CreateStack(newgear);
        } else {
            result = stack;
            Gear.Save(result, newgear);
        }
        return result;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(SimpleGearLocReq.IS_LOWER_THAN_MYTHIC, SimpleGearLocReq.IS_NOT_UNIQUE);
    }

    @Override
    public int getRarityRank() {
        return 4;
    }

    @Override
    public int Tier() {
        return 2;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("When there is hope, there is a way.");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Stone Of Hope";
    }

    @Override
    public String locDescForLangFile() {
        return "Transform any rarity gear into higher rarity";
    }

    @Override
    public int instabilityAddAmount() {
        return 0;
    }
}

