/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.currency.infusions;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.items.currency.CurrencyItem;
import com.robertx22.mine_and_slash.database.items.currency.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.items.currency.ItemAddSecondaryStat;
import com.robertx22.mine_and_slash.database.items.currency.ItemOrbOfTransmutation;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.GearEnumLocReq;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.IHasRecipe;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.professions.recipe.SimpleRecipe;
import com.robertx22.mine_and_slash.saveclasses.gearitem.InfusionData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public abstract class BaseInfusionItem
extends CurrencyItem
implements ICurrencyItemEffect,
IHasRecipe {
    public BaseInfusionItem(String name) {
        super(name);
    }

    @Override
    public boolean activatesBreakRoll() {
        return false;
    }

    public void createInfusion(GearItemData gear) {
        gear.infusion = new InfusionData();
        List<Object> possible = new ArrayList();
        possible = gear.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Armor) ? this.armorInfusions() : (gear.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Weapon) ? this.weaponInfusions() : (gear.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Jewerly) ? this.jewerlyInfusions() : this.jewerlyInfusions()));
        StatMod random = (StatMod)RandomUtils.weightedRandom(possible);
        gear.infusion.Mods = new ArrayList();
        gear.infusion.Mods.add(StatModData.Load(random, 0));
    }

    public abstract List<StatMod> weaponInfusions();

    public abstract List<StatMod> armorInfusions();

    public abstract List<StatMod> jewerlyInfusions();

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        this.createInfusion(gear);
        Gear.Save(stack, gear);
        return stack;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(GearEnumLocReq.INFUSIONS);
    }

    @Override
    public int Tier() {
        return 5;
    }

    @Override
    public int getRarityRank() {
        return 4;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Luck is Etheral and yet affects everything.");
    }

    @Override
    public BaseRecipe getRecipe() {
        return SimpleRecipe.Builder.create(this.GUID(), Professions.TINKERERING).addMaterial(ItemOre.ItemOres.get(this.getRarityRank()), 10).addMaterial(new ItemAddSecondaryStat().getFromForgeRegistry(), 5).addMaterial(new ItemOrbOfTransmutation().getFromForgeRegistry(), 5).addMaterial(Items.field_151042_j, 2).buildMaterials().setOutput(this).levelReq(25).expGained(15).build();
    }
}

