/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.runes.base;

import com.robertx22.mine_and_slash.database.items.currency.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.RuneEmptySlotReq;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.RuneLvlReq;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.RuneNoDuplicateReq;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.ElementalStatMod;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalPeneFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalPenePercent;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalResistFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalSpellDamageFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalSpellDamageMulti;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalSpellDamagePercent;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RuneItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.datasaving.Rune;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BaseRuneItem
extends Item
implements IWeighted,
ICurrencyItemEffect,
IAutoLocName,
ISlashRegistryEntry<BaseRuneItem> {
    public int field_208075_l;

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.RUNE;
    }

    @Override
    public int getRarityRank() {
        return this.field_208075_l;
    }

    public String genRegisryName() {
        return "runes/" + this.name().toLowerCase(Locale.ROOT) + this.field_208075_l;
    }

    public Rarity getRarity() {
        return Rarities.Runes.get(this.getRarityRank());
    }

    @Override
    public int Tier() {
        return 0;
    }

    @Override
    public String locNameForLangFile() {
        Object rar = Rarities.Runes.get(this.field_208075_l);
        return rar.textFormatColor() + this.name().toUpperCase() + " - " + rar.locNameForLangFile() + " Rune";
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Runes;
    }

    @Override
    public String GUID() {
        return this.name();
    }

    @Override
    public int Weight() {
        return 1000;
    }

    public abstract BaseRuneItem byRarity(int var1);

    public BaseRuneItem(int rarity) {
        super(new Item.Properties().func_200917_a(1).func_200915_b(0));
        this.field_208075_l = rarity;
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack currency) {
        GearItemData gear = Gear.Load(stack);
        RuneItemData rune = Rune.Load(currency);
        if (gear != null && rune != null) {
            gear.runes.insert(rune, gear);
            Gear.Save(stack, gear);
        }
        return stack;
    }

    @Override
    public boolean canItemBeModified(LocReqContext context) {
        for (BaseLocRequirement req : this.requirements()) {
            if (!req.isNotAllowed(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(RuneEmptySlotReq.INSTANCE, RuneNoDuplicateReq.INSTANCE, RuneLvlReq.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    public abstract String name();

    public abstract List<StatMod> weaponStat();

    public abstract List<StatMod> armorStat();

    public abstract List<StatMod> jewerlyStat();

    private List<StatMod> allElements(ElementalStatMod mod) {
        return mod.generateAllPossibleStatVariations().stream().filter(x -> ((ElementalStatMod)x).element.isSingleElement).collect(Collectors.toList());
    }

    public List<StatMod> spellDamageFlats() {
        return this.allElements(new ElementalSpellDamageFlat(Elements.Physical));
    }

    public List<StatMod> spellDamageMultis() {
        return this.allElements(new ElementalSpellDamageMulti(Elements.Physical));
    }

    public List<StatMod> resistFlats() {
        return this.allElements(new ElementalResistFlat(Elements.Physical));
    }

    public List<StatMod> peneFlats() {
        return this.allElements(new ElementalPeneFlat(Elements.Physical));
    }

    public List<StatMod> penePercents() {
        return this.allElements(new ElementalPenePercent(Elements.Physical));
    }

    public List<StatMod> spellDamagePercents() {
        return this.allElements(new ElementalSpellDamagePercent(Elements.Physical));
    }
}

