/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.spell_items;

import com.robertx22.mine_and_slash.database.items.spell_items.TomeRenderer;
import com.robertx22.mine_and_slash.database.spells.bases.BaseSpell;
import com.robertx22.mine_and_slash.items.gearitems.bases.MyForgeItem;
import com.robertx22.mine_and_slash.saveclasses.item_classes.SpellItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Spell;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ItemUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RepairUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public abstract class BaseSpellItem
extends Item
implements IAutoLocName,
MyForgeItem {
    public TextFormatting color = TextFormatting.RED;
    public Elements element;
    public ResourceLocation texture = null;

    @Override
    public abstract String GUID();

    public abstract BaseSpell Spell();

    public BaseSpellItem(Elements element) {
        super(BaseSpellItem.getSpellItemProp());
        this.element = element;
        this.setupTexture();
        this.setRegistryName(this.GUID().toLowerCase());
    }

    public BaseSpellItem() {
        super(BaseSpellItem.getSpellItemProp());
        this.setupTexture();
        this.setRegistryName(this.GUID().toLowerCase());
    }

    private void setupTexture() {
        this.texture = new ResourceLocation("mmorpg", "textures/tomes/" + this.Spell().Element().name().toLowerCase() + ".png");
    }

    public static Item.Properties getSpellItemProp() {
        Item.Properties prop = ItemUtils.getDefaultGearProperties().func_200917_a(0).func_200915_b(500);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> prop.setTEISR(TomeRenderer::new));
        return prop;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Spells;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public final int func_77626_a(ItemStack stack) {
        return this.Spell().useTimeTicks();
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity playerIn) {
        if (playerIn instanceof PlayerEntity) {
            try {
                SpellItemData data = Spell.Load(stack);
                if (this.Spell().CanCast((PlayerEntity)playerIn, data)) {
                    this.Spell().cast(worldIn, (PlayerEntity)playerIn, playerIn.func_184600_cs(), 5, data);
                    stack.func_222118_a(1, playerIn, entity -> {
                        if (entity != null) {
                            entity.func_213361_c(EquipmentSlotType.MAINHAND);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (RepairUtils.isItemBroken(stack)) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        player.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }
}

