/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.unique_items.rings;

import com.robertx22.mine_and_slash.database.items.unique_items.IElementalUnique;
import com.robertx22.mine_and_slash.database.items.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.items.unique_items.StatReq;
import com.robertx22.mine_and_slash.database.items.unique_items.bases.BaseUniqueRing;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.IntelligenceFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.resources.ManaOnHitFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalPeneFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalSpellDamageFlat;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class RingElemental
extends BaseUniqueRing
implements IElementalUnique {
    public Elements element;
    static StatReq req = new StatReq(LvlPointStat.INTELLIGENCE, StatReq.Size.NORMAL);

    public RingElemental(Elements element) {
        this.element = element;
    }

    @Override
    public StatReq getRequirements() {
        return req;
    }

    @Override
    public List<StatMod> uniqueStats() {
        return Arrays.asList(new ManaOnHitFlat().multi(3.0f), new IntelligenceFlat(), new ElementalPeneFlat(this.element));
    }

    @Override
    public List<StatMod> primaryStats() {
        return Arrays.asList(new ElementalSpellDamageFlat(this.element).multi(1.25f));
    }

    @Override
    public String locDescForLangFile() {
        return "I summon " + this.element.dmgName + " in my name!";
    }

    @Override
    public String locNameForLangFile() {
        return TextFormatting.YELLOW + "Ring of " + this.element.disasterName;
    }

    @Override
    public String GUID() {
        return this.element.name().toLowerCase() + "_ele_ring0";
    }

    @Override
    public int getRarityRank() {
        return 5;
    }

    @Override
    public int Tier() {
        return 5;
    }

    @Override
    public IUnique newInstance(Elements element) {
        return new RingElemental(element);
    }
}

