/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.unique_items.shields;

import com.robertx22.mine_and_slash.database.items.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.items.unique_items.StatReq;
import com.robertx22.mine_and_slash.database.items.unique_items.bases.BaseUniqueShield;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.flat.BlockStrengthFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.BlockReflectFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalAffinityFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalResistFlat;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IGenerated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class ShieldElemental
extends BaseUniqueShield
implements IGenerated<IUnique> {
    public Elements element;
    static StatReq req = new StatReq(LvlPointStat.WISDOM, StatReq.Size.NORMAL);

    public ShieldElemental(Elements element) {
        this.element = element;
    }

    @Override
    public StatReq getRequirements() {
        return req;
    }

    @Override
    public List<StatMod> uniqueStats() {
        return Arrays.asList(new ElementalAffinityFlat(this.element).multi(0.5f), new ElementalResistFlat(this.element));
    }

    @Override
    public String locDescForLangFile() {
        return "Fear no " + this.element.dmgName;
    }

    @Override
    public String locNameForLangFile() {
        return TextFormatting.YELLOW + "Shield of " + this.element.dmgName + " Thorns";
    }

    @Override
    public List<StatMod> primaryStats() {
        return Arrays.asList(new BlockStrengthFlat(), new BlockReflectFlat(this.element));
    }

    @Override
    public String GUID() {
        return this.element.name().toLowerCase() + "_ele_shield0";
    }

    @Override
    public int getRarityRank() {
        return 3;
    }

    @Override
    public int Tier() {
        return 8;
    }

    @Override
    public List<IUnique> generateAllPossibleStatVariations() {
        ArrayList<IUnique> list = new ArrayList<IUnique>();
        Elements.getAllSingleElements().forEach(x -> list.add(new ShieldElemental((Elements)x)));
        return list;
    }
}

