/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.unique_items.swords;

import com.robertx22.mine_and_slash.database.items.unique_items.IElementalUnique;
import com.robertx22.mine_and_slash.database.items.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.items.unique_items.StatReq;
import com.robertx22.mine_and_slash.database.items.unique_items.bases.BaseUniqueSword;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.flat.offense.CriticalHitFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalAttackDamageFlat;
import com.robertx22.mine_and_slash.database.stats.mods.percent.ElementalSpellToAttackDMGPercent;
import com.robertx22.mine_and_slash.database.stats.mods.percent.offense.CriticalDamagePercent;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class ElementalSaber
extends BaseUniqueSword
implements IElementalUnique {
    public Elements element;
    static StatReq req = new StatReq(LvlPointStat.INTELLIGENCE, StatReq.Size.MEDIUM, LvlPointStat.STAMINA, StatReq.Size.TINY);

    public ElementalSaber(Elements element) {
        this.element = element;
    }

    @Override
    public StatReq getRequirements() {
        return req;
    }

    @Override
    public List<StatMod> uniqueStats() {
        return Arrays.asList(new CriticalHitFlat().multi(2.0f), new CriticalDamagePercent(), new ElementalSpellToAttackDMGPercent(this.element).multi(3.0f));
    }

    @Override
    public List<StatMod> primaryStats() {
        return Arrays.asList(new ElementalAttackDamageFlat(this.element).multi(0.5f));
    }

    @Override
    public String locDescForLangFile() {
        return "Let " + this.element.name() + " guide you.";
    }

    @Override
    public String locNameForLangFile() {
        return TextFormatting.YELLOW + "Saber of " + this.element.dmgName + " madness";
    }

    @Override
    public String GUID() {
        return this.element.name().toLowerCase() + "_ele_saber0";
    }

    @Override
    public int getRarityRank() {
        return 4;
    }

    @Override
    public int Tier() {
        return 14;
    }

    @Override
    public IUnique newInstance(Elements element) {
        return new ElementalSaber(element);
    }
}

