/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.runewords;

import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.items.runes.base.BaseRuneItem;
import com.robertx22.mine_and_slash.database.items.runes.base.BaseUniqueRuneItem;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class RuneWord
implements IGUID,
IWeighted,
IAutoLocName,
ISlashRegistryEntry<RuneWord> {
    public abstract List<StatMod> mods();

    @Override
    public abstract String GUID();

    @Override
    public int Tier() {
        return 0;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    public Rarity getRarity() {
        return Rarities.Runes.get(this.getRarityRank());
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.RUNEWORD;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.word." + this.formattedGUID();
    }

    public abstract List<BaseRuneItem> runes();

    public int size() {
        return this.runes().size();
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Rune_Words;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    public String getRuneWordCombo() {
        String text = "";
        for (BaseRuneItem item : this.runes()) {
            text = text + item.name().toUpperCase();
        }
        return text;
    }

    public ITextComponent getRuneWordComboString() {
        StringTextComponent comp = new StringTextComponent("");
        int current = 0;
        for (BaseRuneItem item : this.runes()) {
            String runetext = item.name().toUpperCase();
            if (current < this.runes().size() - 1) {
                runetext = runetext + " + ";
            }
            if (item instanceof BaseUniqueRuneItem) {
                comp.func_150258_a(TextFormatting.YELLOW + runetext);
            } else {
                comp.func_150258_a(TextFormatting.GREEN + runetext);
            }
            ++current;
        }
        return comp;
    }

    public boolean runesMatch(String word) {
        return this.getRuneWordCombo().equals(word);
    }
}

