/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells;

import com.robertx22.mine_and_slash.database.items.spell_items.ItemBonusEleAtkDmg;
import com.robertx22.mine_and_slash.database.spells.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.bases.EffectCalculation;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalSpellDamage;
import com.robertx22.mine_and_slash.potion_effects.all.BonusDmgPotion;
import com.robertx22.mine_and_slash.saveclasses.item_classes.SpellItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IGenerated;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SpellBonusEleBasicDmg
extends BaseSpell
implements IGenerated<BaseSpell> {
    public Elements element = Elements.Physical;

    public SpellBonusEleBasicDmg(Elements element) {
        this.element = element;
    }

    @Override
    public BaseSpell.SpellType Type() {
        return BaseSpell.SpellType.Self_Buff;
    }

    @Override
    public String GUID() {
        return this.element.dmgName.toLowerCase() + "bonus_basic_atk_dmg_spell";
    }

    @Override
    public int ManaCost() {
        return 50;
    }

    @Override
    public int useTimeTicks() {
        return 20;
    }

    @Override
    public int BaseValue() {
        return 5;
    }

    @Override
    public EffectCalculation ScalingValue() {
        return new EffectCalculation(new ElementalSpellDamage(this.element), 0.5f);
    }

    @Override
    public Elements Element() {
        return this.element;
    }

    @Override
    public Item SpellItem() {
        return ItemBonusEleAtkDmg.MAP.get(this.element);
    }

    @Override
    public ITextComponent GetDescription(SpellItemData data) {
        return CLOC.tooltip("ele_bonus_atk_dmg_spell");
    }

    @Override
    public boolean cast(World world, PlayerEntity caster, Hand hand, int ticksInUse, SpellItemData data) {
        int amp = data.GetDamage(Load.Unit((ICapabilityProvider)caster).getUnit());
        caster.func_195064_c(new EffectInstance((Effect)BonusDmgPotion.MAP.get(this.element), 2400, amp));
        return true;
    }

    @Override
    public List<BaseSpell> generateAllPossibleStatVariations() {
        ArrayList<BaseSpell> spells = new ArrayList<BaseSpell>();
        Elements.getAllSingleElements().forEach(x -> spells.add(new SpellBonusEleBasicDmg((Elements)x)));
        return spells;
    }
}

