/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.bases;

import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.spells.bases.EffectCalculation;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.NoEnergyPacket;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.SpellItemData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class BaseSpell
implements IWeighted,
IGUID,
ISlashRegistryEntry<BaseSpell> {
    public int DamageVariance = 50;
    public boolean ScalesWithLevel = true;

    public boolean use3dBookModel() {
        return true;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    public Rarity getRarity() {
        return Rarities.Spells.get(this.getRarityRank());
    }

    @Override
    public int Tier() {
        return 0;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.SPELL;
    }

    public String typeString() {
        return this.Type().toString().replaceAll("_", " ");
    }

    public boolean hasScalingValue() {
        return true;
    }

    public boolean baseValueScalesWithLevel() {
        return true;
    }

    public abstract SpellType Type();

    @Override
    public abstract String GUID();

    public abstract int ManaCost();

    public abstract int useTimeTicks();

    public float getUseDurationInSeconds() {
        return (float)this.useTimeTicks() / 20.0f;
    }

    public abstract int BaseValue();

    public abstract EffectCalculation ScalingValue();

    public abstract Elements Element();

    public abstract Item SpellItem();

    public abstract ITextComponent GetDescription(SpellItemData var1);

    @Override
    public int Weight() {
        return 1000;
    }

    public abstract boolean cast(World var1, PlayerEntity var2, Hand var3, int var4, SpellItemData var5);

    public boolean CanCast(PlayerEntity caster, SpellItemData data) {
        EntityCap.UnitData unit;
        if (!caster.field_70170_p.field_72995_K && (unit = Load.Unit((ICapabilityProvider)caster)) != null) {
            if (data.level > unit.getLevel()) {
                caster.func_145747_a(Chats.You_are_too_low_level.locName());
                return false;
            }
            ResourcesData.Context ctx = new ResourcesData.Context(unit, (LivingEntity)caster, ResourcesData.Type.MANA, data.GetManaCost(unit), ResourcesData.Use.SPEND);
            if (unit.getResources().hasEnough(ctx)) {
                unit.getResources().modify(ctx);
                return true;
            }
            if (caster instanceof ServerPlayerEntity) {
                MMORPG.sendToClient(new NoEnergyPacket(), (ServerPlayerEntity)caster);
            }
        }
        return false;
    }

    public static enum SpellType {
        Single_Target_Projectile,
        Aoe_Projectile,
        Self_Heal,
        Aoe_Bomb_Projectile,
        Restore_Energy,
        Aoe_Damage_Nova,
        Self_Buff;

    }
}

