/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.bases;

import com.robertx22.mine_and_slash.database.spells.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.entities.bases.IMyRenderAsItem;
import com.robertx22.mine_and_slash.database.spells.entities.bases.IShootableProjectile;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IBuffableSpell;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EntityBaseProjectile
extends AbstractArrowEntity
implements IProjectile,
IMyRenderAsItem,
IBuffableSpell,
IShootableProjectile {
    Entity homingTarget = null;
    public float shootSpeed = 1.3f;
    public float charge = 0.0f;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    protected boolean field_70254_i;
    public int throwableShake;
    protected LivingEntity thrower;
    private String throwerName;
    private int ticksInGround;
    private int ticksInAir;
    private int deathTime = 80;
    private int airProcTime;
    private boolean doGroundProc;
    public Entity ignoreEntity;
    public IBuffableSpell.SpellBuffType buff = IBuffableSpell.SpellBuffType.None;
    public BaseSpell.SpellType spellType = BaseSpell.SpellType.Self_Heal;

    public abstract double radius();

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void setBuffType(BaseSpell.SpellType type) {
        this.spellType = type;
    }

    @Override
    public BaseSpell.SpellType getBuffType() {
        return this.spellType;
    }

    @Override
    public void setBuff(IBuffableSpell.SpellBuffType buff) {
        this.buff = buff;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    protected boolean onExpireProc(LivingEntity caster) {
        return true;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return new ArrayList<ItemStack>();
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    @Override
    public IBuffableSpell.SpellBuffType getBuff() {
        return this.buff;
    }

    public boolean getDoExpireProc() {
        return this.doGroundProc;
    }

    public int getTicksInAir() {
        return this.ticksInAir;
    }

    public int getTicksInGround() {
        return this.ticksInGround;
    }

    public void setTicksInAir(int newVal) {
        this.ticksInAir = newVal;
    }

    public void setTicksInGround(int newVal) {
        this.ticksInGround = newVal;
    }

    public int getAirProcTime() {
        return this.airProcTime;
    }

    public void setAirProcTime(int newVal) {
        this.airProcTime = newVal;
    }

    public int getDeathTime() {
        return this.deathTime;
    }

    public void setDeathTime(int newVal) {
        this.deathTime = newVal;
    }

    public void setDoExpireProc(boolean newVal) {
        this.doGroundProc = newVal;
    }

    public EntityBaseProjectile(EntityType<? extends Entity> type, World worldIn) {
        super(type, worldIn);
    }

    @Nullable
    public LivingEntity getEntityHit(RayTraceResult result, double radius) {
        EntityRayTraceResult enres = null;
        if (result instanceof EntityRayTraceResult) {
            enres = (EntityRayTraceResult)result;
        }
        if (enres != null && enres.func_216348_a() instanceof LivingEntity && enres.func_216348_a() != this.getThrower()) {
            return (LivingEntity)enres.func_216348_a();
        }
        List<LivingEntity> entities = Utilities.getEntitiesWithinRadius(radius, (Entity)this, LivingEntity.class);
        if (entities.size() > 0) {
            LivingEntity closest = entities.get(0);
            for (LivingEntity en : entities) {
                if (en == closest || !(this.func_70032_d((Entity)en) < this.func_70032_d((Entity)closest))) continue;
                closest = en;
            }
            if (closest == this.getThrower()) {
                return null;
            }
            return closest;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213317_d(new Vec3d(x, y, z));
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.checkHoming();
        if (this.field_70173_aa >= this.getDeathTime()) {
            this.onExpireProc(this.getThrower());
            this.func_70106_y();
        }
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vec3d pos, Vec3d posPlusMotion) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)pos, (Vec3d)posPlusMotion, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), e -> !e.func_175149_v() && e.func_70067_L() && e instanceof LivingEntity && e != this.thrower && e != this.ignoreEntity);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.onImpact(raytraceResultIn);
            this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
            BlockState blockstate = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
            Vec3d vec3d = blockraytraceresult.func_216347_e().func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_213317_d(vec3d);
            Vec3d vec3d1 = vec3d.func_72432_b().func_186678_a((double)0.05f);
            this.field_70165_t -= vec3d1.field_72450_a;
            this.field_70163_u -= vec3d1.field_72448_b;
            this.field_70161_v -= vec3d1.field_72449_c;
            this.field_70254_i = true;
            this.onImpact((RayTraceResult)blockraytraceresult);
            blockstate.func_215690_a(this.field_70170_p, blockstate, blockraytraceresult, (Entity)this);
        }
    }

    public void checkHoming() {
        if (this.getBuff().equals((Object)IBuffableSpell.SpellBuffType.Homing_Projectile) && !this.field_70132_H && !this.field_70170_p.field_72995_K) {
            double seekingRange = 5.0;
            if (this.homingTarget == null || !this.homingTarget.func_70089_S()) {
                List entities = Utilities.getEntitiesWithinRadius(seekingRange, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p).stream().filter(x -> x.func_70089_S()).collect(Collectors.toList());
                for (Entity possibleTarget : entities) {
                    if (this.homingTarget != null && !(this.func_70032_d(this.homingTarget) > this.func_70032_d(possibleTarget)) || !Load.hasUnit((ICapabilityProvider)possibleTarget) || possibleTarget.equals((Object)this.getThrower())) continue;
                    this.homingTarget = possibleTarget;
                    this.func_189654_d(true);
                    this.func_213293_j(this.func_213322_ci().field_72450_a / 5.0, this.func_213322_ci().field_72448_b / 5.0, this.func_213322_ci().field_72449_c / 5.0);
                }
            }
            if (this.homingTarget != null && Math.abs(this.func_213322_ci().field_72450_a) < 5.0 && Math.abs(this.func_213322_ci().field_72448_b) < 5.0 && Math.abs(this.func_213322_ci().field_72449_c) < 5.0) {
                this.func_70024_g((this.homingTarget.field_70165_t - this.field_70165_t) / 30.0, (this.homingTarget.field_70163_u + (double)(this.homingTarget.func_213302_cg() / 2.0f) - this.field_70163_u) / 30.0, (this.homingTarget.field_70161_v - this.field_70161_v) / 30.0);
            }
        }
    }

    protected abstract void onImpact(RayTraceResult var1);

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        compound.func_74776_a("charge", this.charge);
        compound.func_74774_a("shake", (byte)this.throwableShake);
        compound.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        if ((this.throwerName == null || this.throwerName.isEmpty()) && this.thrower instanceof PlayerEntity) {
            this.throwerName = this.thrower.func_200200_C_().toString();
        }
        compound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
        compound.func_74757_a("doGroundProc", this.getDoExpireProc());
        compound.func_74768_a("airProcTime", this.getAirProcTime());
        compound.func_74768_a("deathTime", this.getDeathTime());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.charge = compound.func_74760_g("charge");
        this.throwableShake = compound.func_74771_c("shake") & 0xFF;
        this.field_70254_i = compound.func_74771_c("inGround") == 1;
        this.thrower = null;
        this.throwerName = compound.func_74779_i("ownerName");
        if (this.throwerName != null && this.throwerName.isEmpty()) {
            this.throwerName = null;
        }
        this.thrower = this.getThrower();
        this.setDoExpireProc(compound.func_74767_n("doGroundProc"));
        this.setAirProcTime(compound.func_74762_e("airProcTime"));
        this.setDeathTime(compound.func_74762_e("deathTime"));
    }

    @Nullable
    public LivingEntity getThrower() {
        block6: {
            try {
                if (this.thrower != null || this.throwerName == null || this.throwerName.isEmpty()) break block6;
                UUID id = UUID.fromString(this.throwerName);
                if (((ServerWorld)this.field_70170_p).func_217461_a(id) instanceof LivingEntity) {
                    this.thrower = (LivingEntity)((ServerWorld)this.field_70170_p).func_217461_a(UUID.fromString(this.throwerName));
                }
                if (this.thrower != null || !(this.field_70170_p instanceof ServerWorld)) break block6;
                try {
                    Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(UUID.fromString(this.throwerName));
                    if (entity instanceof LivingEntity) {
                        this.thrower = (LivingEntity)entity;
                    }
                }
                catch (Throwable var2) {
                    this.thrower = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.thrower;
    }

    protected void setPos(LivingEntity caster) {
        Vec3d look = caster.func_70040_Z();
        this.func_70107_b(caster.field_70165_t - look.field_72450_a, caster.field_70163_u - look.field_72448_b + 1.3, caster.field_70161_v - look.field_72449_c);
    }
}

