/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.bases;

import com.robertx22.mine_and_slash.database.spells.entities.bases.EntityElementalBolt;
import com.robertx22.mine_and_slash.potion_effects.all.EnergyRegenPotion;
import com.robertx22.mine_and_slash.potion_effects.all.ManaRegenPotion;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IBuffableSpell;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ElementalParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Utilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class EntityBombProjectile
extends EntityElementalBolt {
    @Override
    public double radius() {
        return 4.0;
    }

    public EntityBombProjectile(EntityType<? extends Entity> type, World worldIn) {
        super(type, worldIn);
        this.setDeathTime(30);
        this.setAirProcTime(30);
        this.setDoExpireProc(true);
        this.shootSpeed = 1.3f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70254_i) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean onExpireProc(LivingEntity caster) {
        return this.doEffect(caster);
    }

    public boolean doEffect(LivingEntity caster) {
        if (this.field_70173_aa < this.getAirProcTime()) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            SoundUtils.playSound((Entity)this, SoundEvents.field_187539_bB, 0.6f, 0.6f);
        } else {
            ElementalParticleUtils.SpawnAoeParticle(this.element(), (Entity)this, this.radius(), 300);
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197627_t, true, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 1.0, 1.0);
        }
        if (!this.field_70170_p.field_72995_K && caster != null && this.effect != null) {
            List<LivingEntity> list = Utilities.getEntitiesWithinRadius(this.radius(), (Entity)this, LivingEntity.class);
            for (int i = 0; i < list.size(); ++i) {
                LivingEntity entity = list.get(i);
                if (!Load.hasUnit((ICapabilityProvider)entity)) continue;
                this.effect.Activate(this.data, entity);
                this.checkOnKill(entity);
            }
        }
        return true;
    }

    public void checkOnKill(LivingEntity entity) {
        if (!entity.func_70089_S() && this.getThrower() != null) {
            if (this.getBuff().equals((Object)IBuffableSpell.SpellBuffType.Energy_Regen)) {
                this.getThrower().func_195064_c(new EffectInstance((Effect)EnergyRegenPotion.INSTANCE, 400, 2));
            } else if (this.getBuff().equals((Object)IBuffableSpell.SpellBuffType.Mana_Regen)) {
                this.getThrower().func_195064_c(new EffectInstance((Effect)ManaRegenPotion.INSTANCE, 400, 2));
            }
        }
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        switch (result.func_216346_c()) {
            case BLOCK: {
                this.func_213293_j(0.0, 0.0, 0.0);
                break;
            }
            case ENTITY: {
                break;
            }
        }
    }
}

