/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.bases;

import com.robertx22.mine_and_slash.database.spells.bases.BaseSpellEffect;
import com.robertx22.mine_and_slash.database.spells.bases.DamageData;
import com.robertx22.mine_and_slash.database.spells.entities.bases.EntityBaseProjectile;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellBuffEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IBuffableSpell;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ElementalParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityElementalBolt
extends EntityBaseProjectile {
    protected BaseSpellEffect effect;
    protected DamageData data;
    public List<LivingEntity> entitiesHit = new ArrayList<LivingEntity>();
    int ticks = 0;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return new ItemStack((IItemProvider)this.element().projectileItem);
    }

    public abstract Elements element();

    public EntityElementalBolt(EntityType<? extends Entity> type, World worldIn) {
        super(type, worldIn);
        this.shootSpeed = 1.75f;
    }

    @Override
    public double radius() {
        return 0.5;
    }

    protected void entityInit() {
    }

    public void SetReady(BaseSpellEffect effect, DamageData data) {
        this.effect = effect;
        this.data = data;
    }

    public void ifDamageKilledEnemy(LivingEntity enemy) {
        if (enemy.func_110143_aJ() <= 0.0f) {
            // empty if block
        }
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        LivingEntity entityHit = this.getEntityHit(result, 0.3);
        if (entityHit != null && this.effect != null && this.data != null) {
            if (this.field_70170_p.field_72995_K) {
                SoundUtils.playSound((Entity)this, SoundEvents.field_187543_bD, 0.4f, 0.9f);
            }
            if (!this.entitiesHit.contains(entityHit)) {
                this.effect.Activate(this.data, entityHit);
                this.ifDamageKilledEnemy(entityHit);
                this.entitiesHit.add(entityHit);
            }
        } else if (this.field_70170_p.field_72995_K) {
            SoundUtils.playSound((Entity)this, SoundEvents.field_187843_fX, 0.7f, 0.9f);
        }
        if (!this.field_70170_p.field_72995_K && !this.getBuff().equals((Object)IBuffableSpell.SpellBuffType.Ghost_Projectile)) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
            return;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa > 2) {
            BasicParticleType particle = ParticleTypes.field_197622_o;
            if (this.element().equals(Elements.Water)) {
                particle = ParticleTypes.field_203217_T;
            } else if (this.element().equals(Elements.Fire)) {
                particle = ParticleTypes.field_197631_x;
            } else if (this.element().equals(Elements.Thunder)) {
                particle = ParticleTypes.field_197607_R;
            } else if (this.element().equals(Elements.Nature)) {
                particle = ParticleTypes.field_218420_D;
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195590_a((IParticleData)particle, true, this.field_70165_t + (double)this.field_70146_Z.nextFloat() * 0.2 - 0.1, this.field_70163_u + (double)(this.func_213302_cg() / 2.0f) + (double)this.field_70146_Z.nextFloat() * 0.2 - 0.1, this.field_70161_v + (double)this.field_70146_Z.nextFloat() * 0.2 - 0.1, 0.0, 0.0, 0.0);
            }
        }
        ++this.ticks;
        if (this.ticks > 1) {
            this.ticks = 0;
            ElementalParticleUtils.SpawnAoeParticle(this.element(), (Entity)this, 0.15f, 15);
        }
    }

    @Override
    public void SpawnAndShoot(BaseSpellEffect effect, DamageData data, LivingEntity caster) {
        this.spellType = data.spellItem.GetSpell().Type();
        SpellBuffEffect spelleffect = new SpellBuffEffect(caster, this);
        spelleffect.Activate();
        this.ignoreEntity = caster;
        this.thrower = caster;
        this.SetReady(effect, data);
        this.setPos(caster);
        this.func_184547_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, this.shootSpeed, 0.5f);
        WorldUtils.spawnEntity(this.field_70170_p, (Entity)this);
    }
}

