/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.nova;

import com.robertx22.mine_and_slash.database.spells.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.bases.DamageData;
import com.robertx22.mine_and_slash.database.spells.bases.EffectCalculation;
import com.robertx22.mine_and_slash.database.spells.bases.SpellEffectDamage;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.saveclasses.item_classes.SpellItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ElementalParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Utilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class BaseNovaSpell
extends BaseSpell {
    public float scaling = 0.5f;
    public double radius = 4.0;

    @Override
    public int useTimeTicks() {
        return 15;
    }

    @Override
    public BaseSpell.SpellType Type() {
        return BaseSpell.SpellType.Aoe_Damage_Nova;
    }

    @Override
    public int ManaCost() {
        return 25;
    }

    @Override
    public int BaseValue() {
        return 10;
    }

    @Override
    public ITextComponent GetDescription(SpellItemData data) {
        return CLOC.tooltip("aoe_spell_nova");
    }

    @Override
    public EffectCalculation ScalingValue() {
        return new EffectCalculation(new ElementalResist(this.Element()), this.scaling);
    }

    @Override
    public boolean cast(World world, PlayerEntity caster, Hand hand, int ticksInUse, SpellItemData data) {
        if (!world.field_72995_K) {
            ElementalParticleUtils.SpawnNovaParticle(this.Element(), (Entity)caster, this.radius, 200);
            List<LivingEntity> list = Utilities.getEntitiesWithinRadius(this.radius, 2.0, (Entity)caster, LivingEntity.class);
            for (int i = 0; i < list.size(); ++i) {
                LivingEntity entity1 = list.get(i);
                if (!Load.hasUnit((ICapabilityProvider)entity1) || entity1 == caster) continue;
                entity1.func_184185_a(SoundEvents.field_187903_gc, 0.7f, 0.0f);
                SpellEffectDamage effect = new SpellEffectDamage(this.Element());
                effect.Activate(new DamageData((LivingEntity)caster, data), entity1);
            }
        }
        SoundUtils.playSoundAtPlayer(caster, SoundEvents.field_193784_dd, 1.0f, 1.0f);
        caster.func_184609_a(hand);
        return true;
    }
}

