/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats;

import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.StatRangeContext;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatTypes;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class NormalStatTooltipUtils {
    public static List<ITextComponent> getTooltipList(TooltipStatInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        ITextComponent text = NormalStatTooltipUtils.getValueComp(info).func_150258_a(" ").func_150257_a(NormalStatTooltipUtils.getStatComp(info)).func_150257_a(StatTypes.getSuffix(info.type));
        if (Screen.hasShiftDown() && !info.tooltipInfo.isSet && info.statRange != null) {
            text.func_150257_a(NormalStatTooltipUtils.getNumberRanges(info.statRange));
        }
        list.add(text);
        if (Screen.hasAltDown()) {
            list.add(Styles.BLUECOMP().func_150258_a(" [").func_150257_a(info.stat.locDesc().func_150258_a("]")));
        }
        return list;
    }

    public static ITextComponent getNumberRanges(StatRangeContext ctx) {
        MinMax minmax = ctx.minmax;
        StatModData data = ctx.modData;
        int level = ctx.level;
        StatModData min = StatModData.Load(data.getStatMod(), minmax.Min);
        StatModData max = StatModData.Load(data.getStatMod(), minmax.Max);
        return Styles.GREENCOMP().func_150257_a((ITextComponent)new StringTextComponent(" (" + min.printValue(level) + " - " + max.printValue(level) + ")"));
    }

    public static ITextComponent getStatComp(TooltipStatInfo info) {
        Stat stat = info.stat;
        StringTextComponent str = new StringTextComponent("");
        if (info.type.equals((Object)StatTypes.Percent) && stat.IsPercent()) {
            if (info.amount > 0.0f) {
                str.func_150257_a(Words.Increased.locName());
            } else {
                str.func_150257_a(Words.Decreased.locName());
            }
            str.func_150258_a(" ");
        }
        str.func_150257_a(stat.locName());
        if (!info.tooltipInfo.isSet) {
            return Styles.GRAYCOMP().func_150257_a((ITextComponent)str);
        }
        return Styles.GREENCOMP().func_150257_a((ITextComponent)str);
    }

    public static ITextComponent getValueComp(TooltipStatInfo info) {
        float val = info.amount;
        String minusplus = val > 0.0f ? "+" : "";
        TextFormatting color = TextFormatting.GREEN;
        if (val < 0.0f) {
            color = TextFormatting.RED;
        }
        StringTextComponent comp = new StringTextComponent("");
        comp.func_150258_a(color + minusplus + info.stat.printValue(info.amount));
        comp.func_150257_a(StatTypes.getNumberSuffix(info.type, info.stat));
        comp.func_150258_a(TextFormatting.RESET + "");
        return comp;
    }
}

