/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats;

import com.robertx22.mine_and_slash.database.stats.NormalStatTooltipUtils;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatTypes;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PrimaryStatTooltipUtils {
    public static ITextComponent NameText(TooltipStatInfo info) {
        Stat stat = info.stat;
        StringTextComponent str = new StringTextComponent("");
        if (info.type.equals((Object)StatTypes.Flat) && stat.IsPercent()) {
            str.func_150257_a(Words.Flat.locName()).func_150258_a(" ");
        }
        str.func_150257_a(stat.locName());
        if (!info.tooltipInfo.isSet) {
            return Styles.REDCOMP().func_150257_a(new StringTextComponent(" " + stat.getFormattedIcon() + " ").func_150257_a((ITextComponent)str).func_150258_a(": "));
        }
        return Styles.GREENCOMP().func_150257_a(str.func_150258_a(": "));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ITextComponent NameAndValueText(TooltipStatInfo info) {
        float val = info.amount;
        String minusplus = val > 0.0f ? "+" : "";
        return PrimaryStatTooltipUtils.NameText(info).func_150258_a(minusplus + info.stat.printValue(info.amount));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<ITextComponent> getTooltipList(TooltipStatInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        StatTypes type = info.type;
        Stat stat = info.stat;
        ITextComponent text = PrimaryStatTooltipUtils.NameAndValueText(info);
        if (type == StatTypes.Flat) {
            if (stat.IsPercent()) {
                text.func_150258_a("%");
            }
        } else if (type == StatTypes.Percent) {
            text.func_150258_a("%");
            if (type.equals((Object)StatTypes.Percent) && stat.IsPercent()) {
                if (info.amount > 0.0f) {
                    text.func_150258_a(" ").func_150257_a(Words.Increased.locName());
                } else {
                    text.func_150258_a(" ").func_150257_a(Words.Decreased.locName());
                }
            }
        } else {
            text.func_150258_a("% ").func_150257_a(Words.Multi.locName());
        }
        if (Screen.hasShiftDown() && !info.tooltipInfo.isSet && info.statRange != null) {
            text.func_150257_a(NormalStatTooltipUtils.getNumberRanges(info.statRange));
        }
        list.add(text);
        if (Screen.hasAltDown()) {
            list.add(Styles.BLUECOMP().func_150258_a(" [").func_150257_a(info.stat.locDesc().func_150258_a("]")));
        }
        return list;
    }
}

