/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats;

import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.stats.NormalStatTooltipUtils;
import com.robertx22.mine_and_slash.database.stats.PrimaryStatTooltipUtils;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StatUtils;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Stat
implements IGUID,
IAutoLocName,
IWeighted,
IRarity,
IAutoLocDesc,
ISlashRegistryEntry {
    public int maximumValue = Integer.MAX_VALUE;
    public int minimumValue = Integer.MIN_VALUE;
    public int BaseFlat = 0;

    public TextFormatting getIconFormat() {
        if (this.Element() != null) {
            return this.Element().format;
        }
        return Elements.Physical.format;
    }

    public boolean hasSameLevelScaling(Stat other) {
        return other.ScalesToLevel() && this.ScalesToLevel() || other.ScalesToLevel() && !this.ScalesToLevel();
    }

    public String getIcon() {
        if (this.Element() != null) {
            return this.Element().icon;
        }
        return Elements.Physical.icon;
    }

    public String getFormattedIcon() {
        return this.getIconFormat() + this.getIcon();
    }

    @Override
    public int Tier() {
        return 0;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    public Rarity getRarity() {
        return Rarities.Items.get(this.getRarityRank());
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.STAT;
    }

    public String getIconPath() {
        return "";
    }

    public ResourceLocation getIconLocation() {
        if (this.getIconPath().isEmpty()) {
            return new ResourceLocation("mmorpg", "textures/gui/stat_icons/default.png");
        }
        return new ResourceLocation("mmorpg", "textures/gui/stat_icons/" + this.getIconPath() + ".png");
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.Stats;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.stat." + this.formattedGUID();
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.stat_desc." + this.formattedGUID();
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Stats;
    }

    public abstract boolean IsPercent();

    public abstract boolean ScalesToLevel();

    public abstract Elements Element();

    public String printValue(StatModData data, int level) {
        float val = data.GetActualVal(level);
        return this.printValue(val);
    }

    public float calculateScalingStatGrowth(float stat, int lvl) {
        return StatUtils.calculateNormalScalingStatGrowth(stat, lvl);
    }

    public float roundScalingStatGrowth(float stat, int lvl) {
        return StatUtils.roundNumber(this.calculateScalingStatGrowth(stat, lvl));
    }

    public String printValue(float val) {
        DecimalFormat format = new DecimalFormat();
        if (val < 10.0f) {
            format.setMaximumFractionDigits(1);
            return format.format(val);
        }
        int intval = (int)val;
        return intval + "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipList(TooltipStatInfo info) {
        if (info.tooltipInfo.usePrettyStatSymbols) {
            return PrimaryStatTooltipUtils.getTooltipList(info);
        }
        return NormalStatTooltipUtils.getTooltipList(info);
    }

    public void CalcVal(StatData data, EntityCap.UnitData Source) {
        float finalValue = this.BaseFlat;
        if (this.ScalesToLevel()) {
            finalValue *= (float)Source.getLevel();
        }
        finalValue += data.Flat;
        finalValue *= 1.0f + data.Percent / 100.0f;
        data.Value = MathHelper.func_76131_a((float)(finalValue *= 1.0f + data.Multi / 100.0f), (float)this.minimumValue, (float)this.maximumValue);
    }

    public boolean IsShownOnStatGui() {
        return true;
    }

    public StatGroup statGroup() {
        return StatGroup.Misc;
    }

    public static enum StatGroup {
        Main(Words.Main, 0),
        Misc(Words.Misc, 8),
        CoreStat(Words.Core_Stat, 5),
        SpellDamage(Words.Spell_Damage, 3),
        EleAttackDamage(Words.Elemental_Attack_Damage, 2),
        Defenses(Words.Defenses, 4),
        Penetration(Words.Penetration, 6),
        Damage(Words.Damage, 1),
        Regeneration(Words.Regeneration, 7);

        public Words word;
        public final int width = 18;
        public final int height = 18;
        public int place = 0;
        public final int Y = 8;

        private StatGroup(Words word, int place) {
            this.place = place;
            this.word = word;
        }

        public int X() {
            return 25 + 18 * this.place;
        }
    }
}

