/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats;

import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;

public abstract class StatMod
implements IWeighted,
IRarity,
IGUID,
ISlashRegistryEntry<StatMod> {
    public float multiplier = 1.0f;

    public float sizeMultiplier() {
        return this.multiplier;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.STATMOD;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    public Rarity getRarity() {
        return Rarities.Items.get(this.getRarityRank());
    }

    @Override
    public int Tier() {
        return 0;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    public abstract Stat GetBaseStat();

    public abstract float Min();

    public abstract float Max();

    public abstract StatTypes Type();

    @Override
    public String GUID() {
        return this.GetBaseStat().GUID() + "_" + this.Type().name();
    }

    public float getFloatByPercent(int percent) {
        return (this.Min() + (this.Max() - this.Min()) * (float)percent / 100.0f) * this.multiplier;
    }

    public float getFloatByPercentWithoutMin(int percent) {
        return this.Max() * (float)percent / 100.0f * this.multiplier;
    }

    public StatMod multi(float multiplier) {
        this.multiplier = multiplier;
        return this;
    }
}

