/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.types;

import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.Trait;
import com.robertx22.mine_and_slash.database.stats.types.traits.major_arcana.INameSuffix;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BaseTrait
extends Stat {
    public static String MAJOR_ARCANA = "\u25c8";
    public static String SYMBOL = "\u2299";

    @Override
    public boolean IsPercent() {
        return false;
    }

    @Override
    public boolean ScalesToLevel() {
        return false;
    }

    @Override
    public boolean IsShownOnStatGui() {
        return false;
    }

    @Override
    public void CalcVal(StatData data, EntityCap.UnitData Source) {
        data.Value = data.Flat > 0.0f ? 1.0f : 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent TraitText(TooltipStatInfo info) {
        Stat basestat = info.stat;
        ITextComponent comp = Styles.GREENCOMP().func_150257_a(new StringTextComponent(" " + SYMBOL + " ").func_150257_a(basestat.locName()));
        if (basestat instanceof INameSuffix) {
            INameSuffix suffix = (INameSuffix)((Object)basestat);
            comp.func_150258_a(TextFormatting.LIGHT_PURPLE + " " + MAJOR_ARCANA + "  (");
            comp.func_150257_a(suffix.locSuffix().func_150258_a(") " + MAJOR_ARCANA));
        }
        return comp;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipList(TooltipStatInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        Stat basestat = info.stat;
        StringTextComponent text = new StringTextComponent("");
        text = this.TraitText(info);
        list.add((ITextComponent)text);
        if (Screen.hasShiftDown() && basestat instanceof Trait) {
            Trait trait = (Trait)basestat;
            for (StatModData moddata : trait.getStatsMods()) {
                TooltipInfo newinfo = info.tooltipInfo.withLevel(info.tooltipInfo.unitdata.getLevel());
                newinfo.minmax = new MinMax(trait.percent(), trait.percent());
                list.addAll(moddata.GetTooltipString(newinfo));
            }
        }
        if (Screen.hasShiftDown() && !this.locDescForLangFile().isEmpty()) {
            list.add(new StringTextComponent(TextFormatting.BLUE + "[").func_150257_a(this.locDesc()).func_150258_a("]"));
        }
        return list;
    }
}

