/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.types.generated;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.TransferMethod;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalAttackDamage;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalSpellDamage;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IGenerated;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatTransfer;
import java.util.ArrayList;
import java.util.List;

public class ElementalTransfer
extends Stat
implements IStatTransfer,
IGenerated<Stat> {
    List<TransferMethod> transfers = new ArrayList<TransferMethod>();
    public String GUID;
    public Elements fromElement;
    public Elements toElement;

    @Override
    public String locDescForLangFile() {
        return "Transfer takes a % from 1 and gives to the other";
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.stat_desc.elemental_transfer";
    }

    @Override
    public boolean IsShownOnStatGui() {
        return false;
    }

    @Override
    public boolean IsPercent() {
        return true;
    }

    @Override
    public boolean ScalesToLevel() {
        return false;
    }

    @Override
    public Elements Element() {
        return null;
    }

    public ElementalTransfer(Elements from, Elements to) {
        this.fromElement = from;
        this.toElement = to;
        this.maximumValue = 100;
        this.GUID = from.name() + "_to_" + to.name() + "_transfer";
        this.GUID = this.GUID.toLowerCase();
        this.transfers.add(new TransferMethod(new ElementalAttackDamage(from), new ElementalAttackDamage(to)));
        this.transfers.add(new TransferMethod(new ElementalSpellDamage(from), new ElementalSpellDamage(to)));
    }

    @Override
    public List<TransferMethod> Transfer() {
        return this.transfers;
    }

    @Override
    public List<Stat> generateAllPossibleStatVariations() {
        ArrayList<Stat> stats = new ArrayList<Stat>();
        for (Elements from : Elements.getAllSingleElements()) {
            if (from == Elements.Physical) continue;
            for (Elements to : Elements.getAllSingleElements()) {
                if (to == Elements.Physical || to == from) continue;
                ElementalTransfer stat = new ElementalTransfer(from, to);
                stats.add(stat);
            }
        }
        return stats;
    }

    @Override
    public String GUID() {
        return this.GUID;
    }

    @Override
    public String locNameForLangFile() {
        return "Transfer " + this.fromElement.name() + " to " + this.toElement.name();
    }
}

