/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.talent_tree;

import com.robertx22.mine_and_slash.database.talent_tree.PerkConnection;
import com.robertx22.mine_and_slash.database.talent_tree.PerkEffect;
import com.robertx22.mine_and_slash.database.talent_tree.PerkType;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.capability.PlayerTalentsCap;
import java.util.ArrayList;
import java.util.List;

public class Perk
implements ISlashRegistryEntry<Perk> {
    public List<Perk> connections = new ArrayList<Perk>();
    public PerkEffect effect;
    private String guid;
    public int x;
    public int y;
    public boolean isStart = false;

    public Perk(String guid) {
        this.guid = guid;
    }

    public void render(int x, int y) {
        this.effect.render(x, y);
    }

    public Perk setAsStart() {
        this.isStart = true;
        return this;
    }

    public PerkType getPerkType() {
        if (this.effect.type == PerkType.MAJOR) {
            if (this.effect.isGameChanger()) {
                return this.effect.type;
            }
            return PerkType.BIG;
        }
        return this.effect.type;
    }

    public boolean tryConnectTo(Perk other) {
        if (this.equals(other)) {
            return false;
        }
        boolean added = false;
        if (!this.connections.contains(other)) {
            this.connections.add(other);
            added = true;
        }
        if (!other.connections.contains(this)) {
            other.connections.add(this);
            added = true;
        }
        return added;
    }

    public PerkConnection.Allocation getStatus(PlayerTalentsCap.IPlayerTalentsData data) {
        if (data.getData().isAllocated(this)) {
            return PerkConnection.Allocation.ALLOCATED;
        }
        if (this.isStart && data.getAllocatedPoints() == 0) {
            return PerkConnection.Allocation.CAN_ALLOCATE;
        }
        boolean hascon = false;
        for (Perk con : this.connections) {
            if (!data.getData().isAllocated(con)) continue;
            hascon = true;
        }
        if (hascon) {
            return PerkConnection.Allocation.CAN_ALLOCATE;
        }
        return PerkConnection.Allocation.CANT_ALLOCATE;
    }

    public boolean isConnectedTo(Perk talent) {
        for (Perk con : this.connections) {
            if (!con.GUID().equals(talent.GUID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String GUID() {
        return this.guid;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.PERK;
    }

    @Override
    public int Weight() {
        return 1000;
    }

    @Override
    public int getRarityRank() {
        return 0;
    }

    public Rarity getRarity() {
        return Rarities.Items.get(this.getRarityRank());
    }

    @Override
    public int Tier() {
        return 0;
    }
}

