/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.talent_tree;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.talent_tree.PerkEffect;
import com.robertx22.mine_and_slash.database.talent_tree.PerkEffectsWrapper;
import com.robertx22.mine_and_slash.database.talent_tree.PerkType;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PerkEffectBuilder {
    public static PerkEffectsWrapper build(String id, PerkEffect ... effects) {
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        for (PerkEffect effect : effects) {
            stats.addAll(effect.exactStats);
        }
        return PerkEffectBuilder.build(id, stats);
    }

    public static PerkEffect trait(String guid, Stat stat, PerkType type) {
        ExactStatData data = new ExactStatData(100.0f, StatTypes.Flat, stat.GUID());
        return new PerkEffect(guid, data, stat).type(type);
    }

    public static PerkEffectsWrapper build(String guid, Stat stat, float num, StatTypes type) {
        ExactStatData statdata = new ExactStatData(num, type, stat);
        return PerkEffectBuilder.build(guid, stat, statdata);
    }

    public static PerkEffectsWrapper build(String guid, Stat stat, ExactStatData data) {
        HashMap<PerkType, PerkEffect> map = new HashMap<PerkType, PerkEffect>();
        for (PerkType type : PerkType.values()) {
            ExactStatData data2 = new ExactStatData(data);
            data2.setValue(data2.getValue() * type.statMulti);
            String id = guid + "_" + type.name().toLowerCase();
            PerkEffect neww = new PerkEffect(id, data2, stat).type(type);
            map.put(type, neww);
        }
        return new PerkEffectsWrapper(map);
    }

    public static PerkEffectsWrapper build(String guid, List<ExactStatData> list) {
        HashMap<PerkType, PerkEffect> map = new HashMap<PerkType, PerkEffect>();
        for (PerkType type : PerkType.values()) {
            ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
            for (ExactStatData x : list) {
                ExactStatData stat = new ExactStatData(x);
                stat.setValue(stat.getValue() * type.statMulti);
                stats.add(stat);
            }
            String id = guid + "_" + type.name().toLowerCase();
            PerkEffect neww = new PerkEffect(id, stats, guid).type(type);
            map.put(type, neww);
        }
        return new PerkEffectsWrapper(map);
    }
}

