/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.talent_tree.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.database.talent_tree.PerkConnection;
import com.robertx22.mine_and_slash.database.talent_tree.ScreenContext;
import com.robertx22.mine_and_slash.database.talent_tree.gui.PerkTreeScreen;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.AllocateTalentPacket;
import com.robertx22.mine_and_slash.network.TryRemoveTalentPacket;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.PlayerTalentsCap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.ImageButton;

public class PerkButton
extends ImageButton {
    Perk perk;
    EntityCap.UnitData data;
    Minecraft mc;
    PlayerTalentsCap.IPlayerTalentsData talents;

    public PerkButton(PlayerTalentsCap.IPlayerTalentsData talents, Perk perk, EntityCap.UnitData data) {
        super(0, 0, perk.getPerkType().sizeX, perk.getPerkType().sizeY, 0, 0, perk.getPerkType().sizeY, perk.getPerkType().TEXTURE, button -> {});
        this.perk = perk;
        this.data = data;
        this.mc = Minecraft.func_71410_x();
        this.talents = talents;
    }

    public void renderButton(int x, int y, float ticks) {
    }

    public void renderButton(int x, int y, ScreenContext ctx) {
        int finalY;
        int checkY;
        int finalX = this.getPosX(ctx);
        int checkX = finalX;
        if (PerkTreeScreen.shouldRender(checkX, checkY = (finalY = this.getPosY(ctx)), ctx, this.perk.getPerkType())) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(this.perk.getPerkType().TEXTURE);
            GlStateManager.disableDepthTest();
            PerkConnection.Allocation status = this.perk.getStatus(this.talents);
            float xstart = this.perk.getPerkType().getOffsetX();
            int yStart = this.perk.getPerkType().getOffsetY(status);
            PerkButton.blit((int)finalX, (int)finalY, (float)xstart, (float)yStart, (int)this.width, (int)this.height, (int)256, (int)256);
            GlStateManager.enableDepthTest();
            int itemX = finalX - 8 + this.perk.getPerkType().sizeX / 2;
            int itemY = finalY - 8 + this.perk.getPerkType().sizeY / 2;
            this.perk.render(itemX, itemY);
        }
    }

    public static int getSpacing() {
        return 40;
    }

    public int getMiddleX(ScreenContext ctx) {
        return this.getPosX(ctx) + this.perk.getPerkType().sizeX / 2;
    }

    public int getMiddleY(ScreenContext ctx) {
        return this.getPosY(ctx) + this.perk.getPerkType().sizeY / 2;
    }

    public int getPosX(ScreenContext ctx) {
        int offsetX = this.mc.field_195558_d.func_198107_o() / 2;
        offsetX = (int)((float)offsetX * ctx.getZoomMulti());
        offsetX = (int)((float)offsetX - (float)PerkTreeScreen.sizeX * ctx.zoom / 2.0f);
        return this.getX(ctx) + offsetX;
    }

    public int getPosY(ScreenContext ctx) {
        int offsetY = this.mc.field_195558_d.func_198087_p() / 2;
        offsetY = (int)((float)offsetY * ctx.getZoomMulti());
        offsetY = (int)((float)offsetY - (float)PerkTreeScreen.sizeY * ctx.zoom / 2.0f);
        return this.getY(ctx) + offsetY;
    }

    public int getX(ScreenContext ctx) {
        int pos = (int)(((float)(this.perk.x * PerkButton.getSpacing()) - ctx.scrollX) * ctx.zoom) - this.perk.getPerkType().sizeX / 2;
        return pos;
    }

    public int getY(ScreenContext ctx) {
        int pos = (int)(((float)(this.perk.y * PerkButton.getSpacing()) - ctx.scrollY) * ctx.zoom) - this.perk.getPerkType().sizeY / 2;
        return pos;
    }

    public void onClick(ScreenContext ctx, int mouseX, int mouseY, int click) {
        if (this.isInsideSlot(ctx, mouseX, mouseY)) {
            if (click == 1) {
                MMORPG.sendToServer(new TryRemoveTalentPacket(this.perk));
            } else {
                MMORPG.sendToServer(new AllocateTalentPacket(this.perk));
            }
        }
    }

    public boolean isInsideSlot(ScreenContext ctx, int mouseX, int mouseY) {
        Point guipos = new Point(this.getPosX(ctx), this.getPosY(ctx));
        Point mousePos = new Point((int)((float)mouseX * ctx.getZoomMulti()), (int)((float)mouseY * ctx.getZoomMulti()));
        int xEnd = this.perk.getPerkType().sizeX;
        int yEnd = this.perk.getPerkType().sizeY;
        Point size = new Point(xEnd, yEnd);
        return GuiUtils.isInRectPoints(guipos, size, mousePos);
    }
}

