/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.talent_tree.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.database.talent_tree.PerkConnection;
import com.robertx22.mine_and_slash.database.talent_tree.PerkType;
import com.robertx22.mine_and_slash.database.talent_tree.ScreenContext;
import com.robertx22.mine_and_slash.database.talent_tree.gui.PerkButton;
import com.robertx22.mine_and_slash.database.talent_tree.gui.PerkConnectionRender;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.sync_cap.CapTypes;
import com.robertx22.mine_and_slash.network.sync_cap.RequestSyncCapToClient;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.PlayerTalentsCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.lwjgl.opengl.GL11;

public class PerkTreeScreen
extends Screen {
    Minecraft mc = Minecraft.func_71410_x();
    EntityCap.UnitData data;
    PlayerTalentsCap.IPlayerTalentsData talents;
    public float scrollX = 0.0f;
    public float scrollY = 0.0f;
    public float zoom = 1.0f;
    public static int CENTER_X = 500;
    public static int CENTER_Y = 500;
    private static final ResourceLocation TEXTURE = new ResourceLocation("mmorpg", "textures/gui/talents/talent_frame.png");
    private static final ResourceLocation SPACE = new ResourceLocation("mmorpg", "textures/gui/talents/space.png");
    private static final ResourceLocation LINES = new ResourceLocation("mmorpg", "textures/gui/talents/lines.png");
    public static int sizeX = 318;
    public static int sizeY = 233;
    Set<PerkConnection> connections;
    Set<PerkConnectionRender> buttonConnections;

    public PerkTreeScreen() {
        super((ITextComponent)new StringTextComponent(""));
        this.data = Load.Unit((ICapabilityProvider)this.mc.field_71439_g);
        MMORPG.sendToServer(new RequestSyncCapToClient(CapTypes.TALENTS));
        this.talents = Load.talents((PlayerEntity)this.mc.field_71439_g);
    }

    public void refreshConnections() {
        this.connections = this.talents.getConnections();
        this.buttonConnections = this.getButtonConnections();
    }

    public void init(Minecraft mc, int x, int y) {
        super.init(mc, x, y);
        for (Perk talent : SlashRegistry.Perks().getList()) {
            this.addButton((Widget)new PerkButton(this.talents, talent, this.data));
        }
        this.returnToCenter();
        this.refreshConnections();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean bool = super.keyPressed(keyCode, scanCode, modifiers);
        if (keyCode == 32) {
            this.returnToCenter();
        }
        return bool;
    }

    private void returnToCenter() {
        this.scrollX = PerkButton.getSpacing() * CENTER_X;
        this.scrollY = PerkButton.getSpacing() * CENTER_Y;
        this.scrollX -= (float)(sizeX / 2);
        this.scrollY -= (float)(sizeY / 2);
        this.zoom = 0.6f;
    }

    public boolean mouseDragged(double x, double y, int ticks, double dragX, double dragY) {
        this.scrollX = (float)((double)this.scrollX - dragX * 1.0 / (double)this.zoom);
        this.scrollY = (float)((double)this.scrollY - dragY * 1.0 / (double)this.zoom);
        return true;
    }

    List<PerkButton> getTalentButtons() {
        ArrayList<PerkButton> list = new ArrayList<PerkButton>();
        for (Widget w : this.buttons) {
            if (!(w instanceof PerkButton)) continue;
            list.add((PerkButton)w);
        }
        return list;
    }

    public void render(int x, int y, float ticks) {
        if (this.mc.field_71439_g.field_70173_aa % 100 == 0) {
            MMORPG.sendToServer(new RequestSyncCapToClient(CapTypes.TALENTS));
            this.talents = Load.talents((PlayerEntity)this.mc.field_71439_g);
            this.refreshConnections();
        }
        super.render(x, y, ticks);
        this.drawSpace();
        List<PerkButton> list = this.getTalentButtons();
        this.renderZoomables(x, y, ticks, list);
        this.drawBorders();
        this.drawPointsLeftNumber();
        this.renderTooltips(list, x, y);
    }

    public void renderZoomables(int x, int y, float ticks, List<PerkButton> list) {
        ScreenContext ctx = new ScreenContext(this);
        GL11.glScalef((float)this.zoom, (float)this.zoom, (float)this.zoom);
        this.renderConnections(list);
        for (PerkButton but : list) {
            but.renderButton(x, y, ctx);
        }
        float reset = 1.0f / this.zoom;
        GL11.glScalef((float)reset, (float)reset, (float)reset);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.zoom -= 0.1f;
        }
        if (scroll > 0.0) {
            this.zoom += 0.1f;
        }
        this.zoom = MathHelper.func_76131_a((float)this.zoom, (float)0.23f, (float)1.0f);
        return true;
    }

    public void renderTooltips(List<PerkButton> list, int mouseX, int mouseY) {
        TooltipInfo info = new TooltipInfo();
        ScreenContext ctx = new ScreenContext(this);
        list.forEach(button -> {
            if (button.isInsideSlot(ctx, mouseX, mouseY)) {
                this.renderTooltip(TooltipUtils.compsToStrings(button.perk.effect.GetTooltipString(info)), mouseX, mouseY, this.mc.field_71466_p);
            }
        });
    }

    public boolean mouseReleased(double x, double y, int button) {
        ScreenContext ctx = new ScreenContext(this);
        this.getTalentButtons().forEach(t -> t.onClick(ctx, (int)x, (int)y, button));
        this.refreshConnections();
        return super.mouseReleased(x, y, button);
    }

    private Set<PerkConnectionRender> getButtonConnections() {
        ObjectArraySet conns = new ObjectArraySet();
        List<PerkButton> list = this.getTalentButtons();
        for (PerkConnection connection : this.connections) {
            Optional<PerkButton> but1 = list.stream().filter(button -> button.perk.GUID().equals(connection.one.GUID())).findAny();
            Optional<PerkButton> but2 = list.stream().filter(button -> button.perk.GUID().equals(connection.two.GUID())).findAny();
            if (!but1.isPresent() || !but2.isPresent()) continue;
            conns.add(new PerkConnectionRender(but1.get(), but2.get(), connection));
        }
        return conns;
    }

    private void renderConnections(List<PerkButton> list) {
        ScreenContext ctx = new ScreenContext(this);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LINES);
        for (PerkConnectionRender c : this.buttonConnections) {
            this.renderConnection(c.perk1, c.perk2, c.connection, ctx);
        }
    }

    public static boolean shouldRender(int x, int y, ScreenContext ctx, PerkType type) {
        int perkY;
        int perkX = type == null ? 5 : type.sizeX / 2;
        int n = perkY = type == null ? 5 : type.sizeY / 2;
        return x >= ctx.offsetX + 10 && (float)x < (float)ctx.offsetX + (float)(sizeX - perkX) * ctx.getZoomMulti() - 10.0f && y >= ctx.offsetY + 10 && (float)y < (float)ctx.offsetY + (float)(sizeY - perkY) * ctx.getZoomMulti() - 10.0f;
    }

    private void renderConnection(PerkButton one, PerkButton two, PerkConnection connection, ScreenContext ctx) {
        int x1 = one.getMiddleX(ctx);
        int y1 = one.getMiddleY(ctx);
        int x2 = two.getMiddleX(ctx);
        int y2 = two.getMiddleY(ctx);
        int size = 6;
        float spacing = size + size / 2;
        List<GuiUtils.PointF> points = GuiUtils.generateCurve(new GuiUtils.PointF(x1, y1), new GuiUtils.PointF(x2, y2), 360.0f, spacing, true);
        for (GuiUtils.PointF point : points) {
            int x = (int)(point.x - (float)size / 2.0f);
            int y = (int)(point.y - (float)size / 2.0f);
            if (!PerkTreeScreen.shouldRender(x, y, ctx, null)) continue;
            PerkTreeScreen.blit((int)x, (int)y, (int)0, (float)connection.allocationStatus.spriteOffsetX, (float)0.0f, (int)size, (int)size, (int)256, (int)256);
        }
    }

    protected void drawPointsLeftNumber() {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetX = this.mc.field_195558_d.func_198107_o() / 2 - sizeX / 2;
        int offsetY = this.mc.field_195558_d.func_198087_p() / 2 - sizeY / 2 + 10;
        String str2 = "Reset Points (RMB): " + this.talents.getData().resetPoints;
        this.mc.field_71466_p.func_175063_a(str2, (float)(offsetX + 10), (float)offsetY, TextFormatting.GREEN.func_211163_e().intValue());
        String str = "Points (LMB): " + this.talents.getFreePoints(this.data);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        float f = offsetX + 10;
        this.mc.field_71466_p.getClass();
        fontRenderer.func_175063_a(str, f, (float)(offsetY + 9 + 5), TextFormatting.GREEN.func_211163_e().intValue());
    }

    protected void drawSpace() {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetX = this.mc.field_195558_d.func_198107_o() / 2 - sizeX / 2;
        int offsetY = this.mc.field_195558_d.func_198087_p() / 2 - sizeY / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SPACE);
        PerkTreeScreen.blit((int)(offsetX + 3), (int)(offsetY + 3), (int)this.blitOffset, (float)0.0f, (float)0.0f, (int)(sizeX - 6), (int)(sizeY - 6), (int)2048, (int)2048);
    }

    protected void drawBorders() {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetX = this.mc.field_195558_d.func_198107_o() / 2 - sizeX / 2;
        int offsetY = this.mc.field_195558_d.func_198087_p() / 2 - sizeY / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        PerkTreeScreen.blit((int)offsetX, (int)offsetY, (int)this.blitOffset, (float)0.0f, (float)0.0f, (int)sizeX, (int)sizeY, (int)256, (int)512);
    }
}

