/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.world_providers;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.world_providers.IWP;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.Templates;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.world_gen.types.FeatureType;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ModDimension;

public abstract class BaseWorldProvider
extends Dimension
implements IWP,
IRarity,
ISlashRegistryEntry<BaseWorldProvider> {
    public ModDimension moddim;
    private DimensionType type;
    public static final String RESETTABLE = "resettable";

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.WORLD_PROVIDER;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public int Tier() {
        return 0;
    }

    public Rarity getRarity() {
        return Rarities.Items.get(this.getRarityRank());
    }

    @Override
    public List<FeatureType> smallSurfaceDecorations() {
        return Arrays.asList(Templates.bigWoodPillar, Templates.smallWoodPillar, Templates.lampPillar);
    }

    @Override
    public List<FeatureType> smallTreasures() {
        return Arrays.asList(Templates.smallTreasure0, Templates.smallTreasure1, Templates.smallTreasure2);
    }

    public ResourceLocation res(String str) {
        return new ResourceLocation("mmorpg", str);
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.world_type." + this.formattedGUID();
    }

    @Override
    public void setModDimension(ModDimension mod) {
        this.moddim = mod;
    }

    public abstract BiFunction<World, DimensionType, ? extends Dimension> classFactory();

    @Override
    public float getBonusLootMulti() {
        return 1.0f;
    }

    @Override
    public ModDimension newModDimension() {
        return new ModDimension(){

            public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
                return BaseWorldProvider.this.classFactory();
            }
        };
    }

    public boolean func_191066_m() {
        return true;
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos p_206920_1_, boolean checkValid) {
        for (int i = p_206920_1_.func_180334_c(); i <= p_206920_1_.func_180332_e(); ++i) {
            for (int j = p_206920_1_.func_180333_d(); j <= p_206920_1_.func_180330_f(); ++j) {
                BlockPos blockpos = this.func_206921_a(i, j, checkValid);
                if (blockpos == null) continue;
                return blockpos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(posX, 0, posZ);
        Biome biome = this.field_76579_a.func_180494_b((BlockPos)blockpos$mutableblockpos);
        BlockState blockstate = biome.func_203944_q().func_204108_a();
        if (checkValid && !blockstate.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk chunk = this.field_76579_a.func_212866_a_(posX >> 4, posZ >> 4);
        int i = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, posX & 0xF, posZ & 0xF);
        if (i < 0) {
            return null;
        }
        if (chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, posX & 0xF, posZ & 0xF) > chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, posX & 0xF, posZ & 0xF)) {
            return null;
        }
        for (int j = i + 1; j >= 0; --j) {
            blockpos$mutableblockpos.func_181079_c(posX, j, posZ);
            BlockState blockstate1 = this.field_76579_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!blockstate1.func_204520_s().func_206888_e()) break;
            if (!blockstate1.equals((Object)blockstate)) continue;
            return blockpos$mutableblockpos.func_177984_a().func_185334_h();
        }
        return null;
    }

    @Override
    public ResourceLocation getResourceLoc() {
        return new ResourceLocation("mmorpg", "resettable_" + this.GUID());
    }

    public BaseWorldProvider(World world, DimensionType type) {
        super(world, type);
        this.type = type;
        this.setModDim();
    }

    @Override
    public ModDimension getModDim() {
        return this.moddim;
    }

    public void setModDim() {
        this.moddim = this.newModDimension();
    }

    @Nonnull
    public ChunkGenerator<?> func_186060_c() {
        BiomeProviderType biomeType = BiomeProviderType.field_205461_c;
        ChunkGeneratorType chunkType = ChunkGeneratorType.field_206911_b;
        OverworldGenSettings settings = (OverworldGenSettings)chunkType.func_205483_a();
        SingleBiomeProvider biomeProvider = (SingleBiomeProvider)biomeType.func_205457_a((IBiomeProviderSettings)((SingleBiomeProviderSettings)biomeType.func_205458_a()).func_205436_a(this.getBiome()));
        ChunkGenerator gen = chunkType.create(this.field_76579_a, (BiomeProvider)biomeProvider, (GenerationSettings)settings);
        if (((Boolean)ModConfig.INSTANCE.Server.RESET_MAP_DIMENSIONS_ON_LOAD.get()).booleanValue()) {
            gen.field_222541_b = MMORPG.MAP_WORLD_SEED;
        }
        return gen;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    public boolean func_76569_d() {
        return this.field_76579_a != null && this.field_76579_a.field_72995_K;
    }

    public boolean func_76567_e() {
        return false;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public long getWorldTime() {
        return 18000L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        float f = MathHelper.func_76134_b((float)(p_76562_1_ * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d((double)(f1 *= f * 0.94f + 0.06f), (double)(f2 *= f * 0.94f + 0.06f), (double)(f3 *= f * 0.91f + 0.09f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public DimensionType func_186058_p() {
        return this.type;
    }
}

