/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.db_lists.bases;

import com.robertx22.mine_and_slash.database.requirements.GearRequestedFor;
import com.robertx22.mine_and_slash.db_lists.bases.IRandom;
import com.robertx22.mine_and_slash.db_lists.bases.IhasRequirements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public interface IRandomDefault<T extends IhasRequirements & IWeighted>
extends IRandom<T, GearRequestedFor> {
    @Override
    public HashMap<String, T> All();

    @Override
    default public T random(GearRequestedFor gearRequestedFor) {
        List<T> allThatMeetReq = this.allThatMeetRequirement((List<T>)new ArrayList<T>(this.All().values()), gearRequestedFor);
        if (allThatMeetReq.size() == 0) {
            return null;
        }
        return (T)((IhasRequirements)RandomUtils.weightedRandom(allThatMeetReq));
    }

    @Override
    default public T random() {
        return (T)((IhasRequirements)RandomUtils.weightedRandom(this.All().values()));
    }

    @Override
    default public List<T> allThatMeetRequirement(List<T> list, GearRequestedFor gearRequestedFor) {
        return list.stream().filter(x -> x.requirements().satisfiesAllRequirements(gearRequestedFor)).collect(Collectors.toList());
    }
}

