/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.db_lists.initializers;

import com.robertx22.mine_and_slash.database.world_providers.BaseWorldProvider;
import com.robertx22.mine_and_slash.database.world_providers.BeachIWP;
import com.robertx22.mine_and_slash.database.world_providers.BirchForestIWP;
import com.robertx22.mine_and_slash.database.world_providers.DesertHillsIWP;
import com.robertx22.mine_and_slash.database.world_providers.IWP;
import com.robertx22.mine_and_slash.database.world_providers.NetherIWP;
import com.robertx22.mine_and_slash.database.world_providers.RedDesertIWP;
import com.robertx22.mine_and_slash.database.world_providers.RockDesertIWP;
import com.robertx22.mine_and_slash.database.world_providers.RockMountainsIWP;
import com.robertx22.mine_and_slash.database.world_providers.SavannaIWP;
import com.robertx22.mine_and_slash.database.world_providers.SnowyMountainsIWP;
import com.robertx22.mine_and_slash.database.world_providers.SwampHillsIWP;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryInit;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import net.minecraft.world.biome.Biome;

public class WorldProviders
implements ISlashRegistryInit {
    public static WorldProviders INSTANCE = new WorldProviders();

    public static IWP byBiome(Biome biome) {
        IWP first = null;
        try {
            first = SlashRegistry.WorldProviders().getList().stream().filter(x -> x.getBiome().equals(biome)).findFirst().get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (first != null) {
            return first;
        }
        return new BirchForestIWP(null, null);
    }

    public BaseWorldProvider random(IWPRandomConfig config) {
        return RandomUtils.weightedRandom(SlashRegistry.WorldProviders().getList());
    }

    public BaseWorldProvider random() {
        return this.random(new IWPRandomConfig());
    }

    @Override
    public void registerAll() {
        ArrayList<BaseWorldProvider> All = new ArrayList<BaseWorldProvider>(){
            {
                this.add(new DesertHillsIWP(null, null));
                this.add(new SnowyMountainsIWP(null, null));
                this.add(new SavannaIWP(null, null));
                this.add(new RockDesertIWP(null, null));
                this.add(new RockMountainsIWP(null, null));
                this.add(new BirchForestIWP(null, null));
                this.add(new NetherIWP(null, null));
                this.add(new SwampHillsIWP(null, null));
                this.add(new RedDesertIWP(null, null));
                this.add(new BeachIWP(null, null));
            }
        };
        All.forEach(x -> x.registerToSlashRegistry());
    }

    public static class IWPRandomConfig {
    }
}

