/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.db_lists.registry;

import com.robertx22.mine_and_slash.database.requirements.GearRequestedFor;
import com.robertx22.mine_and_slash.db_lists.bases.IhasRequirements;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.comparators.RarityComparator;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IGearSlotType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FilterListWrap<C extends ISlashRegistryEntry> {
    public List<C> list = new ArrayList<C>();

    public FilterListWrap(List<C> list) {
        this.list = list;
    }

    public FilterListWrap(Collection<C> list) {
        this.list = new ArrayList<C>(list);
    }

    public FilterListWrap<C> ofTierOrLess(int tier) {
        this.list = this.list.stream().filter(x -> x.Tier() <= tier).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofTierRange(int min, int max) {
        this.list = this.list.stream().filter(x -> x.Tier() >= min && x.Tier() <= max).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofExactTier(int tier) {
        this.list = this.list.stream().filter(x -> x.Tier() == tier).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofExactRarity(int rarity) {
        this.list = this.list.stream().filter(x -> x.getRarityRank() == rarity).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofHighestRarity() {
        Optional<IRarity> optional = this.list.stream().max(new RarityComparator());
        if (optional.isPresent()) {
            int highest = ((ISlashRegistryEntry)optional.get()).getRarityRank();
            this.list = this.list.stream().filter(x -> x.getRarityRank() == highest).collect(Collectors.toList());
        } else {
            this.list.clear();
        }
        return this;
    }

    public FilterListWrap<C> ofSpecificGearType(String type) {
        if (!type.isEmpty() && !type.equals("random")) {
            this.list = this.list.stream().filter(x -> ((IGearSlotType)((Object)x)).getGearSlot().GUID().equals(type)).collect(Collectors.toList());
        }
        return this;
    }

    public FilterListWrap<C> randomAmountWithoutDuplicates(int amount) {
        HashSet set = new HashSet();
        while (set.size() < amount) {
            this.list.add(this.random());
        }
        this.list = new ArrayList<C>(set);
        return this;
    }

    public FilterListWrap<C> randomAmount(int amount) {
        ArrayList<C> list = new ArrayList<C>();
        for (int tries = 0; list.size() < amount && tries < 100; ++tries) {
            list.add(this.random());
        }
        this.list = list;
        return this;
    }

    public FilterListWrap<C> allThatMeetRequirement(GearItemData gear) {
        return this.allThatMeetRequirement(new GearRequestedFor(gear));
    }

    public FilterListWrap<C> allThatMeetRequirement(GearRequestedFor request) {
        this.list = this.list.stream().filter(x -> ((IhasRequirements)((Object)x)).meetsRequirements(request)).collect(Collectors.toList());
        return this;
    }

    public C random() {
        if (this.list.isEmpty()) {
            return null;
        }
        return (C)((ISlashRegistryEntry)RandomUtils.weightedRandom(this.list));
    }
}

