/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.db_lists.registry;

import com.robertx22.mine_and_slash.config.compatible_items.ConfigItem;
import com.robertx22.mine_and_slash.config.dimension_configs.DimensionConfig;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.database.affixes.Prefix;
import com.robertx22.mine_and_slash.database.affixes.Suffix;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.item_modifications.bases.BaseItemModification;
import com.robertx22.mine_and_slash.database.item_modifications.gear_items.AddChaosStatMod;
import com.robertx22.mine_and_slash.database.items.currency.CurrencyItem;
import com.robertx22.mine_and_slash.database.items.currency.ItemOrbOfTransmutation;
import com.robertx22.mine_and_slash.database.items.runes.base.BaseRuneItem;
import com.robertx22.mine_and_slash.database.items.runes.base.BaseUniqueRuneItem;
import com.robertx22.mine_and_slash.database.items.runes.unique_runes.PSIItem;
import com.robertx22.mine_and_slash.database.items.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.map_affixes.BaseMapAffix;
import com.robertx22.mine_and_slash.database.runewords.RuneWord;
import com.robertx22.mine_and_slash.database.sets.Set;
import com.robertx22.mine_and_slash.database.spells.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.status_effects.bases.BaseStatusEffect;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.database.talent_tree.PerkEffect;
import com.robertx22.mine_and_slash.database.talent_tree.data.StartPerkEffects;
import com.robertx22.mine_and_slash.database.world_providers.BaseWorldProvider;
import com.robertx22.mine_and_slash.database.world_providers.BirchForestIWP;
import com.robertx22.mine_and_slash.db_lists.initializers.CurrencyItems;
import com.robertx22.mine_and_slash.db_lists.initializers.GearTypes;
import com.robertx22.mine_and_slash.db_lists.initializers.ItemModifications;
import com.robertx22.mine_and_slash.db_lists.initializers.MapAffixes;
import com.robertx22.mine_and_slash.db_lists.initializers.PerkEffectsInit;
import com.robertx22.mine_and_slash.db_lists.initializers.Perks;
import com.robertx22.mine_and_slash.db_lists.initializers.Prefixes;
import com.robertx22.mine_and_slash.db_lists.initializers.RuneWords;
import com.robertx22.mine_and_slash.db_lists.initializers.Runes;
import com.robertx22.mine_and_slash.db_lists.initializers.Sets;
import com.robertx22.mine_and_slash.db_lists.initializers.Spells;
import com.robertx22.mine_and_slash.db_lists.initializers.StatMods;
import com.robertx22.mine_and_slash.db_lists.initializers.Stats;
import com.robertx22.mine_and_slash.db_lists.initializers.StatusEffects;
import com.robertx22.mine_and_slash.db_lists.initializers.Suffixes;
import com.robertx22.mine_and_slash.db_lists.initializers.UniqueGears;
import com.robertx22.mine_and_slash.db_lists.initializers.UniqueRunes;
import com.robertx22.mine_and_slash.db_lists.initializers.WorldProviders;
import com.robertx22.mine_and_slash.db_lists.initializers.profession_recipes.AlchemyRecipes;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.ModEntityContainer;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryContainer;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyGearType;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyMapAffix;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyPrefix;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyRune;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyRuneWord;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptySet;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptySpell;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyStat;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyStatMod;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyStatusEffect;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptySuffix;
import com.robertx22.mine_and_slash.db_lists.registry.empty_entries.EmptyUnique;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import java.util.HashMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.IWorld;

public class SlashRegistry {
    private static HashMap<SlashRegistryType, SlashRegistryContainer> map = new HashMap();

    public static DimensionConfig getDimensionConfig(IWorld world) {
        String id = MapManager.getId(world);
        return SlashRegistry.DimensionConfigs().get(id);
    }

    public static ModEntityConfig getEntityConfig(LivingEntity entity, EntityCap.UnitData data) {
        String monster_id = entity.func_200600_R().getRegistryName().toString();
        String mod_id = entity.func_200600_R().getRegistryName().func_110624_b();
        ModEntityConfig config = null;
        if (SlashRegistry.EntityConfigs().isRegistered(monster_id) ? (config = (ModEntityConfig)SlashRegistry.EntityConfigs().get(monster_id)) != null : (SlashRegistry.EntityConfigs().isRegistered(mod_id) ? (config = (ModEntityConfig)SlashRegistry.EntityConfigs().get(mod_id)) != null : (config = SlashRegistry.EntityConfigs().byEntityTypeDefault.get((Object)data.getType())) != null)) {
            return config;
        }
        return (ModEntityConfig)SlashRegistry.EntityConfigs().getDefault();
    }

    public static SlashRegistryContainer<PerkEffect> PerkEffects() {
        return SlashRegistry.getRegistry(SlashRegistryType.PERK_EFFECT);
    }

    public static SlashRegistryContainer<Perk> Perks() {
        return SlashRegistry.getRegistry(SlashRegistryType.PERK);
    }

    public static SlashRegistryContainer<BaseRecipe> Recipes() {
        return SlashRegistry.getRegistry(SlashRegistryType.RECIPE);
    }

    public static SlashRegistryContainer<CurrencyItem> CurrencyItems() {
        return SlashRegistry.getRegistry(SlashRegistryType.CURRENCY_ITEMS);
    }

    public static SlashRegistryContainer<BaseUniqueRuneItem> UniqueRunes() {
        return SlashRegistry.getRegistry(SlashRegistryType.UNIQUE_RUNES);
    }

    private static SlashRegistryContainer<DimensionConfig> DimensionConfigs() {
        return SlashRegistry.getRegistry(SlashRegistryType.DIMENSION_CONFIGS);
    }

    public static SlashRegistryContainer<BaseItemModification> ItemModifications() {
        return SlashRegistry.getRegistry(SlashRegistryType.ITEM_MODIFICATION);
    }

    public static SlashRegistryContainer<ConfigItem> CompatibleItems() {
        return SlashRegistry.getRegistry(SlashRegistryType.COMPATIBLE_ITEM);
    }

    public static SlashRegistryContainer<BaseStatusEffect> StatusEffects() {
        return SlashRegistry.getRegistry(SlashRegistryType.STATUS_EFFECT);
    }

    public static SlashRegistryContainer<BaseMapAffix> MapAffixes() {
        return SlashRegistry.getRegistry(SlashRegistryType.MAP_AFFIX);
    }

    public static SlashRegistryContainer<IUnique> UniqueGears() {
        return SlashRegistry.getRegistry(SlashRegistryType.UNIQUE_GEAR);
    }

    public static SlashRegistryContainer<Set> Sets() {
        return SlashRegistry.getRegistry(SlashRegistryType.SET);
    }

    public static SlashRegistryContainer<Prefix> Prefixes() {
        return SlashRegistry.getRegistry(SlashRegistryType.PREFIX);
    }

    public static SlashRegistryContainer<Suffix> Suffixes() {
        return SlashRegistry.getRegistry(SlashRegistryType.SUFFIX);
    }

    public static SlashRegistryContainer<GearItemSlot> GearTypes() {
        return SlashRegistry.getRegistry(SlashRegistryType.GEAR_TYPE);
    }

    public static SlashRegistryContainer<BaseSpell> Spells() {
        return SlashRegistry.getRegistry(SlashRegistryType.SPELL);
    }

    public static SlashRegistryContainer<BaseRuneItem> Runes() {
        return SlashRegistry.getRegistry(SlashRegistryType.RUNE);
    }

    public static SlashRegistryContainer<RuneWord> RuneWords() {
        return SlashRegistry.getRegistry(SlashRegistryType.RUNEWORD);
    }

    public static SlashRegistryContainer<BaseWorldProvider> WorldProviders() {
        return SlashRegistry.getRegistry(SlashRegistryType.WORLD_PROVIDER);
    }

    public static ModEntityContainer EntityConfigs() {
        return (ModEntityContainer)SlashRegistry.getRegistry(SlashRegistryType.MOD_ENTITY_CONFIGS);
    }

    public static SlashRegistryContainer<Stat> Stats() {
        return SlashRegistry.getRegistry(SlashRegistryType.STAT);
    }

    public static SlashRegistryContainer<StatMod> StatMods() {
        return SlashRegistry.getRegistry(SlashRegistryType.STATMOD);
    }

    public static SlashRegistryContainer getRegistry(SlashRegistryType type) {
        return map.get((Object)type);
    }

    public static ISlashRegistryEntry get(SlashRegistryType type, String guid) {
        return SlashRegistry.getRegistry(type).get(guid);
    }

    public static void init() {
        try {
            map = new HashMap();
            SlashRegistry.createRegistries();
            SlashRegistry.registerFromAllInits();
        }
        catch (ExceptionInInitializerError e) {
            e.printStackTrace();
            e.getCause().printStackTrace();
        }
    }

    private static void registerFromAllInits() {
        new Spells().registerAll();
        new Stats().registerAll();
        new StatMods().registerAll();
        new Runes().registerAll();
        new RuneWords().registerAll();
        new GearTypes().registerAll();
        new MapAffixes().registerAll();
        new Prefixes().registerAll();
        new Suffixes().registerAll();
        new StatusEffects().registerAll();
        new UniqueGears().registerAll();
        new WorldProviders().registerAll();
        new Sets().registerAll();
        new ItemModifications().registerAll();
        new CurrencyItems().registerAll();
        new UniqueRunes().registerAll();
        new AlchemyRecipes().registerAll();
        new PerkEffectsInit().registerAll();
        new Perks().registerAll();
    }

    private static void createRegistries() {
        map.put(SlashRegistryType.GEAR_TYPE, new SlashRegistryContainer<EmptyGearType>(SlashRegistryType.GEAR_TYPE, new EmptyGearType()));
        map.put(SlashRegistryType.STAT, new SlashRegistryContainer<EmptyStat>(SlashRegistryType.STAT, new EmptyStat()));
        map.put(SlashRegistryType.STATMOD, new SlashRegistryContainer<EmptyStatMod>(SlashRegistryType.STATMOD, new EmptyStatMod()));
        map.put(SlashRegistryType.SET, new SlashRegistryContainer<EmptySet>(SlashRegistryType.SET, new EmptySet()));
        map.put(SlashRegistryType.SPELL, new SlashRegistryContainer<EmptySpell>(SlashRegistryType.SPELL, new EmptySpell()));
        map.put(SlashRegistryType.UNIQUE_GEAR, new SlashRegistryContainer<EmptyUnique>(SlashRegistryType.UNIQUE_GEAR, new EmptyUnique()));
        map.put(SlashRegistryType.UNIQUE_RUNES, new SlashRegistryContainer<PSIItem>(SlashRegistryType.UNIQUE_RUNES, new PSIItem()));
        map.put(SlashRegistryType.SUFFIX, new SlashRegistryContainer<EmptySuffix>(SlashRegistryType.SUFFIX, new EmptySuffix()));
        map.put(SlashRegistryType.PREFIX, new SlashRegistryContainer<EmptyPrefix>(SlashRegistryType.PREFIX, new EmptyPrefix()));
        map.put(SlashRegistryType.RUNE, new SlashRegistryContainer<EmptyRune>(SlashRegistryType.RUNE, new EmptyRune(0)));
        map.put(SlashRegistryType.RUNEWORD, new SlashRegistryContainer<EmptyRuneWord>(SlashRegistryType.RUNEWORD, new EmptyRuneWord()));
        map.put(SlashRegistryType.MAP_AFFIX, new SlashRegistryContainer<EmptyMapAffix>(SlashRegistryType.MAP_AFFIX, new EmptyMapAffix()));
        map.put(SlashRegistryType.STATUS_EFFECT, new SlashRegistryContainer<EmptyStatusEffect>(SlashRegistryType.STATUS_EFFECT, new EmptyStatusEffect()));
        map.put(SlashRegistryType.WORLD_PROVIDER, new SlashRegistryContainer<BirchForestIWP>(SlashRegistryType.WORLD_PROVIDER, new BirchForestIWP(null, null)));
        map.put(SlashRegistryType.ITEM_MODIFICATION, new SlashRegistryContainer<AddChaosStatMod>(SlashRegistryType.ITEM_MODIFICATION, new AddChaosStatMod()));
        map.put(SlashRegistryType.CURRENCY_ITEMS, new SlashRegistryContainer<ItemOrbOfTransmutation>(SlashRegistryType.CURRENCY_ITEMS, new ItemOrbOfTransmutation()));
        map.put(SlashRegistryType.RECIPE, new SlashRegistryContainer<Object>(SlashRegistryType.RECIPE, null));
        map.put(SlashRegistryType.COMPATIBLE_ITEM, new SlashRegistryContainer<ConfigItem>(SlashRegistryType.COMPATIBLE_ITEM, new ConfigItem()).dontErrorIfEmpty().logAdditions());
        map.put(SlashRegistryType.DIMENSION_CONFIGS, new SlashRegistryContainer<DimensionConfig>(SlashRegistryType.DIMENSION_CONFIGS, DimensionConfig.DefaultExtra()).logAdditions().dontErrorMissingEntriesOnAccess());
        map.put(SlashRegistryType.MOD_ENTITY_CONFIGS, new ModEntityContainer(SlashRegistryType.MOD_ENTITY_CONFIGS).logAdditions());
        map.put(SlashRegistryType.PERK, new SlashRegistryContainer<Object>(SlashRegistryType.PERK, null));
        map.put(SlashRegistryType.PERK_EFFECT, new SlashRegistryContainer<PerkEffect>(SlashRegistryType.PERK_EFFECT, StartPerkEffects.GUARDIAN));
    }
}

