/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.db_lists.registry;

import com.robertx22.mine_and_slash.db_lists.registry.FilterListWrap;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SlashRegistryContainer<C extends ISlashRegistryEntry> {
    private List<String> registersErrorsAlertedFor = new ArrayList<String>();
    private List<String> accessorErrosAletedFor = new ArrayList<String>();
    private SlashRegistryType type;
    private C emptyDefault;
    private HashMap<String, C> map = new HashMap();
    private boolean errorIfEmpty = true;
    private boolean logAdditionsToRegistry = false;
    private boolean logMissingEntryOnAccess = true;

    public static void logRegistryError(String text) {
        System.out.println("[Mine and Slash Registry Error]: " + text);
    }

    protected C getDefault() {
        return this.emptyDefault;
    }

    public SlashRegistryContainer logAdditions() {
        this.logAdditionsToRegistry = true;
        return this;
    }

    public SlashRegistryContainer dontErrorMissingEntriesOnAccess() {
        this.logMissingEntryOnAccess = false;
        return this;
    }

    public SlashRegistryContainer dontErrorIfEmpty() {
        this.errorIfEmpty = false;
        return this;
    }

    public int getSize() {
        return this.map.size();
    }

    public SlashRegistryContainer(SlashRegistryType type, C emptyDefault) {
        this.type = type;
        this.emptyDefault = emptyDefault;
    }

    public void setDefault(C c) {
        this.emptyDefault = c;
    }

    private void tryLogEmptyRegistry() {
        if (this.errorIfEmpty && this.map.isEmpty()) {
            SlashRegistryContainer.logRegistryError("Slash Registry of type: " + this.type.toString() + " is empty, this is really bad!");
        }
    }

    public HashMap<String, C> getAll() {
        this.tryLogEmptyRegistry();
        return this.map;
    }

    public List<C> getList() {
        return new ArrayList<C>(this.map.values());
    }

    public C get(String guid) {
        this.tryLogEmptyRegistry();
        if (guid == null || guid.isEmpty()) {
            return this.getDefault();
        }
        if (this.map.containsKey(guid)) {
            return (C)((ISlashRegistryEntry)this.map.get(guid));
        }
        if (this.logMissingEntryOnAccess && !this.accessorErrosAletedFor.contains(guid)) {
            SlashRegistryContainer.logRegistryError("GUID Error: " + guid + " of type: " + this.type.toString() + " doesn't exist. This is either a removed/renamed old registry, or robertx22 forgot to include it in an update.");
            this.accessorErrosAletedFor.add(guid);
        }
        return this.getDefault();
    }

    public FilterListWrap<C> getWrapped() {
        return new FilterListWrap<C>(this.map.values());
    }

    public FilterListWrap<C> getFilterWrapped(Predicate<C> pred) {
        return new FilterListWrap<C>(this.getFiltered(pred));
    }

    public List<C> getFiltered(Predicate<C> predicate) {
        return this.getList().stream().filter(predicate).collect(Collectors.toList());
    }

    public C random() {
        return (C)((ISlashRegistryEntry)RandomUtils.weightedRandom(this.getList()));
    }

    public boolean isRegistered(C c) {
        return this.map.containsKey(c.GUID());
    }

    public boolean isRegistered(String guid) {
        return this.map.containsKey(guid);
    }

    public void registerOverride(C c) {
        if (this.isRegistered(c)) {
            System.out.println("[Mine and Slash Registry Note]: Overriding: " + c.GUID());
        }
        this.map.put(c.GUID(), c);
    }

    public void register(C c) {
        if (this.isRegistered(c)) {
            if (!this.registersErrorsAlertedFor.contains(c.GUID())) {
                SlashRegistryContainer.logRegistryError("Key: " + c.GUID() + " has already been registered to: " + c.getSlashRegistryType().toString() + " registry.");
                this.registersErrorsAlertedFor.add(c.GUID());
            }
        } else {
            this.tryLogAddition(c);
            this.map.put(c.GUID(), c);
        }
    }

    private void tryLogAddition(C c) {
        if (this.logAdditionsToRegistry) {
            System.out.println("[Mine and Slash Registry Addition]: " + c.GUID() + " to " + this.type.toString() + " registry");
        }
    }
}

