/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.bags;

import com.robertx22.mine_and_slash.db_lists.CreativeTabs;
import com.robertx22.mine_and_slash.items.ItemSingle;
import com.robertx22.mine_and_slash.items.bags.BaseInventory;
import com.robertx22.mine_and_slash.uncommon.item_filters.bases.ItemFilterGroup;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Tooltip;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class BaseBagItem
extends Item {
    public int size = 54;
    protected boolean showCraftWarning = true;

    public abstract ItemFilterGroup filterGroup();

    public abstract INamedContainerProvider getNamedContainer(ItemStack var1);

    public BaseBagItem(String name) {
        super(new ItemSingle().func_200916_a(CreativeTabs.MyModTab));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Tooltip.color(TextFormatting.GREEN, Words.PicksUpItemsAuto.locName()));
        tooltip.add(Tooltip.color(TextFormatting.YELLOW, Words.HoldToPreventPickup.locName()));
        Tooltip.addEmpty(tooltip);
        tooltip.add(Tooltip.color(TextFormatting.RED, Words.BewareCreativeBagBug1.locName()));
        tooltip.add(Tooltip.color(TextFormatting.RED, Words.BewareCreativeBagBug2.locName()));
        if (this.showCraftWarning) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add(Tooltip.color(TextFormatting.RED, Words.CraftingDeletesItemsInside.locName()));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K && player.func_184614_ca().func_77973_b() instanceof BaseBagItem) {
            player.func_213829_a(this.getNamedContainer(player.func_184614_ca()));
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public BaseInventory getInventory(ItemStack bag, ItemStack stack) {
        if (stack.func_190916_E() > 0 && this.filterGroup().anyMatchesFilter(stack)) {
            return this.newInventory(bag);
        }
        return null;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b("Parent")) {
            nbt.func_218657_a("Items", nbt.func_74781_a("Parent"));
            stack.func_77982_d(nbt);
        }
        return null;
    }

    public BaseInventory newInventory(ItemStack bag) {
        return new BaseInventory(bag);
    }
}

