/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.gearitems.weapon_mechanics;

import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.items.gearitems.bases.WeaponMechanic;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class HammerWeaponMechanic
extends WeaponMechanic {
    float radius = 1.5f;

    @Override
    public ITextComponent tooltipDesc() {
        return new StringTextComponent(Styles.GREEN + "Aoe Attack");
    }

    @Override
    public float GetEnergyCost(int lvl) {
        return Energy.INSTANCE.calculateScalingStatGrowth(10.0f, lvl);
    }

    @Override
    public WeaponTypes weaponType() {
        return WeaponTypes.Hammer;
    }

    @Override
    public boolean Attack(LivingHurtEvent event, LivingEntity source, LivingEntity target, EntityCap.UnitData unitsource, EntityCap.UnitData targetUnit) {
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (Entity en : target.field_70170_p.func_72839_b((Entity)source, new AxisAlignedBB(target.field_70165_t - (double)this.radius, target.field_70163_u - (double)this.radius, target.field_70161_v - (double)this.radius, target.field_70165_t + (double)this.radius, target.field_70163_u + (double)this.radius, target.field_70161_v + (double)this.radius))) {
            if (!(en instanceof LivingEntity)) continue;
            entities.add((LivingEntity)en);
        }
        int num = (int)unitsource.getUnit().getStat((String)PhysicalDamage.GUID).Value;
        for (LivingEntity entity : entities) {
            DamageEffect dmg;
            if (entity.equals((Object)target)) {
                dmg = new DamageEffect(event, source, entity, num, unitsource, targetUnit, EffectData.EffectTypes.BASIC_ATTACK, WeaponTypes.Hammer);
                dmg.Activate();
                continue;
            }
            dmg = new DamageEffect(null, source, entity, num, unitsource, targetUnit, EffectData.EffectTypes.BASIC_ATTACK, WeaponTypes.Hammer);
            dmg.Activate();
        }
        return true;
    }
}

