/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.profession.alchemy.bases;

import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.BasePotion;
import com.robertx22.mine_and_slash.potion_effects.alchemy_pot_buffs.BaseAlchemyEffect;
import com.robertx22.mine_and_slash.potion_effects.alchemy_pot_buffs.BaseEffect;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Tooltip;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BaseBuffPotion
extends BasePotion {
    public BaseBuffPotion(Professions.Levels lvl) {
        super(lvl);
    }

    public int durationInMinutes() {
        return (int)(this.level.effectMultiplier * 10.0f);
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Alchemy;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    public int useDurationInTicks() {
        return 50;
    }

    public BaseEffect createEffect() {
        return new BaseAlchemyEffect(this);
    }

    public BaseEffect getEffect() {
        return (BaseEffect)ForgeRegistries.POTIONS.getValue(new ResourceLocation("mmorpg", this.GUID()));
    }

    public void onFinish(ItemStack stack, World world, LivingEntity player, EntityCap.UnitData unitdata) {
        player.func_70651_bq().stream().filter(x -> x.func_188419_a() instanceof BaseAlchemyEffect).findFirst().ifPresent(x -> player.func_195063_d(x.func_188419_a()));
        EffectInstance instance = new EffectInstance((Effect)this.getEffect(), this.durationInMinutes() * 20 * 60, 0, false, false);
        player.func_195064_c(instance);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TooltipInfo info = new TooltipInfo(null, new MinMax(100, 100), this.level.number);
        info.usePrettyStatSymbols = true;
        tooltip.add(Styles.GREENCOMP().func_150258_a("Stats: "));
        for (StatModData mod : this.mods()) {
            tooltip.addAll(mod.GetTooltipString(info));
        }
        Tooltip.addEmpty(tooltip);
        tooltip.add(Styles.BLUECOMP().func_150258_a("Duration: " + this.durationInMinutes() + " Minutes"));
        tooltip.add(TooltipUtils.level(this.level.number));
    }

    public abstract List<StatModData> mods();

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return this.useDurationInTicks();
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity player) {
        this.onFinish(stack, world, player, Load.Unit((ICapabilityProvider)player));
        stack.func_190918_g(1);
        if (player instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)player;
            p.func_191521_c(new ItemStack((IItemProvider)Items.field_151069_bo));
        }
        return stack;
    }

    public boolean hasAlchemyPotion(LivingEntity en) {
        return en.func_70651_bq().stream().anyMatch(x -> x.func_188419_a() instanceof BaseAlchemyEffect);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (Load.Unit((ICapabilityProvider)player).getLevel() >= this.level.number) {
            player.func_184598_c(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }
}

