/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.profession.alchemy.single_use;

import com.robertx22.mine_and_slash.items.profession.alchemy.bases.BaseInstantPotion;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.IAmount;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.professions.recipe.SimpleRecipe;
import com.robertx22.mine_and_slash.professions.recipe.builders.SimpleRecipeBuilders;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StatUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class InstantManaPotionItem
extends BaseInstantPotion
implements IAmount {
    float lvl_1_amount = 50.0f;

    public InstantManaPotionItem(Professions.Levels lvl) {
        super(lvl);
    }

    @Override
    public ITextComponent tooltip() {
        StringTextComponent comp = new StringTextComponent("Restores " + this.amount() + " Mana");
        return comp;
    }

    @Override
    public void onFinish(ItemStack stack, World world, LivingEntity player, EntityCap.UnitData unitdata) {
        ResourcesData.Context ctx = new ResourcesData.Context(unitdata, player, ResourcesData.Type.MANA, this.amount(), ResourcesData.Use.RESTORE);
        unitdata.modifyResource(ctx);
    }

    @Override
    public String GUID() {
        return "alchemy/instant/mana/potion_lvl_" + this.level.number;
    }

    @Override
    public float amount() {
        return StatUtils.roundNumber(this.level.effectMultiplier * this.lvl_1_amount);
    }

    @Override
    public String locNameForLangFile() {
        return this.level.color + this.level.name + " Instant Mana Potion";
    }

    @Override
    public BaseRecipe getRecipe() {
        SimpleRecipeBuilders.SimpleRecipeMatBuilder mats = SimpleRecipe.Builder.create(this.GUID(), Professions.ALCHEMY).addMaterial(Items.field_151069_bo, 1).addMaterial(Items.field_222066_kO, 5.0f * this.level.materialCostMulti).addMaterial(Items.field_196128_bn, 5.0f * this.level.materialCostMulti);
        if (this.level.number >= Professions.Levels.FIFTY.number) {
            mats.addMaterial(Items.field_151079_bi, 2.0f * this.level.materialCostMulti);
        }
        return mats.buildMaterials().setOutput(this, 3).levelReq(this.level.number).expGained(10).build();
    }

    @Override
    public BaseInstantPotion newInstance(Professions.Levels lvl) {
        return new InstantManaPotionItem(lvl);
    }
}

