/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.profession.alchemy.single_use;

import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.BaseInstantPotion;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.BasePotion;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.professions.recipe.SimpleRecipe;
import com.robertx22.mine_and_slash.professions.recipe.builders.SimpleRecipeBuilders;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ResetStatsPotionItem
extends BaseInstantPotion {
    public ResetStatsPotionItem() {
        super(Professions.Levels.TEN);
    }

    @Override
    public ITextComponent tooltip() {
        StringTextComponent comp = new StringTextComponent("Removes all allocated Stat Points");
        return comp;
    }

    @Override
    public void onFinish(ItemStack stack, World world, LivingEntity player, EntityCap.UnitData unitdata) {
        if (player instanceof PlayerEntity) {
            Load.statPoints((PlayerEntity)player).resetStats();
        }
    }

    @Override
    public String GUID() {
        return "alchemy/instant/misc/regret" + this.level.number;
    }

    @Override
    public String locNameForLangFile() {
        return this.level.color + this.level.name + " Potion of Regret";
    }

    @Override
    public BaseRecipe getRecipe() {
        SimpleRecipeBuilders.SimpleRecipeMatBuilder mats = SimpleRecipe.Builder.create(this.GUID(), Professions.ALCHEMY).addMaterial(Items.field_151069_bo, 1).addMaterial(Items.field_151150_bK, 2).addMaterial(Items.field_151075_bm, 25).addMaterial(ItemOre.ItemOres.get(5), 5);
        return mats.buildMaterials().setOutput(this).levelReq(this.level.number).expGained(10).build();
    }

    @Override
    public BasePotion newInstance(Professions.Levels lvl) {
        return new ResetStatsPotionItem();
    }

    @Override
    public float amount() {
        return 0.0f;
    }
}

