/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.profession.alchemy.single_use;

import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.BaseInstantPotion;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.BasePotion;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.professions.recipe.SimpleRecipe;
import com.robertx22.mine_and_slash.professions.recipe.builders.SimpleRecipeBuilders;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ResetTalentsPotionItem
extends BaseInstantPotion {
    public ResetTalentsPotionItem() {
        super(Professions.Levels.ONE);
    }

    @Override
    public ITextComponent tooltip() {
        StringTextComponent comp = new StringTextComponent("Resets all your talent points");
        return comp;
    }

    @Override
    public void onFinish(ItemStack stack, World world, LivingEntity player, EntityCap.UnitData unitdata) {
        if (player instanceof PlayerEntity) {
            Load.talents((PlayerEntity)player).reset();
        }
    }

    @Override
    public String GUID() {
        return "alchemy/instant/misc/reset_talents";
    }

    @Override
    public String locNameForLangFile() {
        return this.level.color + this.level.name + " Potion of Reset Talents";
    }

    @Override
    public BaseRecipe getRecipe() {
        SimpleRecipeBuilders.SimpleRecipeMatBuilder mats = SimpleRecipe.Builder.create(this.GUID(), Professions.ALCHEMY).addMaterial(Items.field_151069_bo, 1).addMaterial(Items.field_151045_i, 3).addMaterial(Items.field_151153_ao, 1).addMaterial(ItemOre.ItemOres.get(0), 10);
        return mats.buildMaterials().setOutput(this).levelReq(10).expGained(20).build();
    }

    @Override
    public BasePotion newInstance(Professions.Levels lvl) {
        return new ResetTalentsPotionItem();
    }

    @Override
    public float amount() {
        return 0.0f;
    }
}

