/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot;

import com.robertx22.mine_and_slash.database.stats.types.generated.LootTypeBonus;
import com.robertx22.mine_and_slash.database.world_providers.IWP;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class LootInfo {
    public int amount = 0;
    public int tier = 0;
    public int level = 1;
    public EntityCap.UnitData mobData;
    public EntityCap.UnitData playerData;
    public LivingEntity victim;
    public PlayerEntity killer;
    public World world;
    public float multi = 1.0f;
    public int minItems = 0;
    public int maxItems = 50;

    public LootInfo setMaximum(int max) {
        this.maxItems = max;
        return this;
    }

    public LootInfo setMinimum(int min) {
        this.minItems = min;
        return this;
    }

    public LootInfo setLevel(int level) {
        this.level = level;
        return this;
    }

    public LootInfo setMulti(float multi) {
        this.multi = multi;
        return this;
    }

    public LootInfo setTier() {
        if (this.mobData != null) {
            this.tier = this.mobData.getTier();
        } else if (this.killer != null && WorldUtils.isMapWorld((IWorld)this.killer.field_70170_p)) {
            this.tier = WorldUtils.getTier(this.killer.field_70170_p, this.killer);
        }
        return this;
    }

    public LootInfo(EntityCap.UnitData mob, EntityCap.UnitData player, LivingEntity victim, PlayerEntity killer) {
        this.world = victim.field_70170_p;
        this.mobData = mob;
        this.playerData = player;
        this.victim = victim;
        this.killer = killer;
        this.level = mob.getLevel();
        this.setTier();
    }

    public LootInfo(World theworld) {
        this.world = theworld;
    }

    public LootInfo(PlayerEntity player) {
        this.world = player.field_70170_p;
        this.playerData = Load.Unit((ICapabilityProvider)player);
        this.level = Load.playerMapData(player).getLevel();
        this.setTier();
    }

    public void setup(BaseLootGen gen) {
        float chance = gen.BaseChance();
        chance *= this.multi;
        if (this.victim != null && this.mobData != null) {
            chance = (float)((double)chance * SlashRegistry.getEntityConfig((LivingEntity)this.victim, (EntityCap.UnitData)this.mobData).LOOT_MULTI);
        }
        if (this.playerData != null) {
            chance *= this.playerData.getUnit().getStat(new LootTypeBonus(gen.lootType())).getMultiplier();
            chance *= this.playerData.getUnit().getStat(new LootTypeBonus(LootType.All)).getMultiplier();
            if (this.mobData != null && this.playerData.getLevel() < 5 && this.mobData.getLevel() < 5) {
                chance *= 2.0f;
            }
        }
        if (this.killer != null) {
            chance *= Load.playerMapData(this.killer).getLootMultiplier(this.killer);
        }
        if (this.world != null) {
            chance *= SlashRegistry.getDimensionConfig((IWorld)this.world).DROP_MULTIPLIER;
            if (this.world.func_201675_m() instanceof IWP) {
                IWP iwp = (IWP)this.world.func_201675_m();
                chance *= iwp.getBonusLootMulti();
            }
        }
        if (this.mobData != null && this.victim != null) {
            chance = LootUtils.applyLootMultipliers(chance, this.mobData, this.victim);
        }
        if (this.mobData != null && this.playerData != null && gen.hasLevelDistancePunishment()) {
            chance = LootUtils.ApplyLevelDistancePunishment(this.mobData, this.playerData, chance);
        }
        this.amount = LootUtils.WhileRoll(chance);
    }
}

