/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class LootUtils {
    static final int LEVEL_DISTANCE_PUNISHMENT_ACTIVATION = 5;

    public static float ApplyLevelDistancePunishment(EntityCap.UnitData mob, EntityCap.UnitData player, float chance) {
        int difference = Math.abs(player.getLevel() - mob.getLevel());
        int maxlvl = (Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get();
        if (difference > 5) {
            if (player.getLevel() == maxlvl && mob.getLevel() > maxlvl) {
                return chance;
            }
            float levelDiff = 1.0f;
            levelDiff = player.getLevel() > mob.getLevel() ? (float)mob.getLevel() / (float)player.getLevel() : (float)player.getLevel() / (float)mob.getLevel();
            if (levelDiff > 1.0f) {
                levelDiff = 1.0f;
            }
            return chance * levelDiff;
        }
        return chance;
    }

    public static ItemStack RandomDamagedGear(ItemStack stack, Rarity rar, int level) {
        if (stack.func_77984_f()) {
            float lvlDuraPenalty = level < 10 ? -0.1f : (level < 30 ? 0.0f : 0.2f);
            float dmgMulti = (float)RandomUtils.RandomRange(rar.SpawnDurabilityHit().Min, rar.SpawnDurabilityHit().Max) / 100.0f;
            dmgMulti += lvlDuraPenalty;
            dmgMulti = MathHelper.func_76131_a((float)dmgMulti, (float)0.0f, (float)0.95f);
            stack.func_196085_b((int)(dmgMulti * (float)stack.func_77958_k()));
        }
        return stack;
    }

    public static float applyLootMultipliers(float chance, EntityCap.UnitData mob, LivingEntity entity) {
        float first = chance;
        float after_rarity = first * ((MobRarity)Rarities.Mobs.get(mob.getRarity())).LootMultiplier();
        float after_mob_health = after_rarity * (1.0f + entity.func_110138_aP() / 20.0f);
        if (entity instanceof SlimeEntity) {
            after_mob_health /= 15.0f;
        }
        return after_mob_health;
    }

    public static int WhileRoll(float chance) {
        int amount = 0;
        while (chance > 0.0f) {
            float currentChance = chance;
            float maxChance = 75.0f;
            if (currentChance > maxChance) {
                currentChance = maxChance;
            }
            chance -= currentChance;
            if (!RandomUtils.roll(currentChance)) continue;
            ++amount;
        }
        return amount;
    }
}

