/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.rarities.RaritiesContainer;
import com.robertx22.mine_and_slash.database.rarities.containers.ItemRarities;
import com.robertx22.mine_and_slash.database.requirements.GearRequestedFor;
import com.robertx22.mine_and_slash.database.sets.Set;
import com.robertx22.mine_and_slash.db_lists.initializers.Sets;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;

public class GearBlueprint
extends ItemBlueprint {
    public String gearType = "";
    public boolean RandomGearType = true;
    public float chaosStatChance = 1.0f;
    public boolean isCustomSetChance = false;
    public float customSetChance = 0.0f;

    public GearBlueprint(int level) {
        super(level);
    }

    @Override
    public RaritiesContainer<? extends Rarity> getRarityContainer() {
        return new ItemRarities();
    }

    public boolean getsChaosStats() {
        return RandomUtils.roll(this.chaosStatChance);
    }

    @Override
    public void SetSpecificType(String type) {
        this.gearType = type;
        this.RandomGearType = false;
        try {
            SlashRegistry.GearTypes().get(type);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public GearItemSlot GetGearType() {
        if (this.RandomGearType) {
            return RandomUtils.weightedRandom(SlashRegistry.GearTypes().getList());
        }
        return SlashRegistry.GearTypes().get(this.gearType);
    }

    public void SetCustomSetChance(float chance) {
        this.isCustomSetChance = true;
        this.customSetChance = chance;
    }

    public boolean canGetSet(GearItemData data) {
        Set set = (Set)Sets.INTANCE.random(new GearRequestedFor(data));
        if (set == null) {
            return false;
        }
        return this.isCustomSetChance ? RandomUtils.roll(this.customSetChance) : RandomUtils.roll(data.getRarity().SetChance());
    }
}

