/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.gens;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.config.compatible_items.ConfigItem;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CompatibleItemLootGen
extends BaseLootGen {
    public CompatibleItemLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float BaseChance() {
        return ((Double)ModConfig.INSTANCE.DropRates.COMPATIBLE_ITEMS_DROPRATE.get()).floatValue();
    }

    @Override
    public LootType lootType() {
        return LootType.CompatibleItem;
    }

    @Override
    public boolean condition() {
        return (Boolean)ModConfig.INSTANCE.Server.USE_COMPATIBILITY_ITEMS.get();
    }

    @Override
    public ItemStack generateOne() {
        if (((Boolean)ModConfig.INSTANCE.Server.USE_COMPATIBILITY_ITEMS.get()).booleanValue() && this.info.mobData != null) {
            return CompatibleItemLootGen.gen(this.info.mobData.getLevel());
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack gen(int level) {
        try {
            ResourceLocation res;
            ConfigItem config = (ConfigItem)RandomUtils.weightedRandom(SlashRegistry.CompatibleItems().getList().stream().filter(x -> x.dropsAsLoot).collect(Collectors.toList()));
            if (config != null && ForgeRegistries.ITEMS.containsKey(res = new ResourceLocation(config.registryName))) {
                ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(res));
                return config.create(stack, level);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ItemStack.field_190927_a;
    }
}

