/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.gens;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.items.runes.base.BaseRuneItem;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.RuneBlueprint;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RuneItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Rune;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class RuneLootGen
extends BaseLootGen {
    public RuneLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float BaseChance() {
        return ((Double)ModConfig.INSTANCE.DropRates.RUNE_DROPRATE.get()).floatValue();
    }

    @Override
    public LootType lootType() {
        return LootType.Rune;
    }

    @Override
    public ItemStack generateOne() {
        RuneBlueprint runePrint = new RuneBlueprint(this.info.level);
        return RuneLootGen.Create(runePrint);
    }

    public static ItemStack Create(RuneBlueprint blueprint) {
        BaseRuneItem item = blueprint.getRuneItem().byRarity(blueprint.getRarityRank());
        ItemStack stack = new ItemStack((IItemProvider)item);
        RuneItemData data = new RuneItemData();
        data.rarity = item.field_208075_l;
        data.name = item.GUID();
        data.level = blueprint.level;
        data.armor = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(item.armorStat()));
        data.weapon = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(item.weaponStat()));
        data.jewerly = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(item.jewerlyStat()));
        Rune.Save(stack, data);
        return stack;
    }
}

