/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.gens;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.loot.blueprints.RunedGearBlueprint;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.loot.gens.GearLootGen;
import com.robertx22.mine_and_slash.saveclasses.gearitem.GearItemEnum;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class RunedGearLootGen
extends BaseLootGen {
    public RunedGearLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float BaseChance() {
        return ((Double)ModConfig.INSTANCE.DropRates.RUNED_GEAR_DROPRATE.get()).floatValue();
    }

    @Override
    public LootType lootType() {
        return LootType.RunedItem;
    }

    @Override
    public ItemStack generateOne() {
        RunedGearBlueprint gearPrint = new RunedGearBlueprint(this.info.level);
        ItemStack stack = RunedGearLootGen.CreateStack(gearPrint);
        GearItemData gear = Gear.Load(stack);
        return LootUtils.RandomDamagedGear(stack, gear.getRarity(), gear.level);
    }

    public static GearItemData CreateData(RunedGearBlueprint blueprint) {
        return GearLootGen.CreateData(blueprint, GearItemEnum.RUNED);
    }

    public static ItemStack CreateStack(RunedGearBlueprint schema) {
        GearItemData data = RunedGearLootGen.CreateData(schema);
        ItemStack stack = new ItemStack((IItemProvider)data.getItem());
        Gear.Save(stack, data);
        return stack;
    }

    public static ItemStack CreateStack(GearItemData data) {
        ItemStack stack = new ItemStack((IItemProvider)data.getItem());
        Gear.Save(stack, data);
        return stack;
    }
}

