/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.gens;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.rarities.SpellRarity;
import com.robertx22.mine_and_slash.database.spells.bases.BaseSpell;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.loot.blueprints.SpellBlueprint;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.saveclasses.item_classes.SpellItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Spell;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class SpellLootGen
extends BaseLootGen {
    public SpellLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float BaseChance() {
        return ((Double)ModConfig.INSTANCE.DropRates.SPELL_DROPRATE.get()).floatValue();
    }

    @Override
    public LootType lootType() {
        return LootType.Spell;
    }

    @Override
    public ItemStack generateOne() {
        SpellBlueprint spellPrint = new SpellBlueprint(this.info.level);
        return SpellLootGen.Create(spellPrint);
    }

    public static ItemStack Create(SpellBlueprint blueprint) {
        BaseSpell spell = blueprint.GetSpell();
        ItemStack stack = new ItemStack((IItemProvider)spell.SpellItem());
        SpellItemData data = new SpellItemData();
        data.rarity = blueprint.getRarityRank();
        SpellRarity rarity = data.getRarity();
        data.rarity = rarity.Rank();
        data.spellGUID = spell.GUID();
        data.level = blueprint.getLevel();
        data.baseEffectPercent = RandomUtils.RandomRange(rarity.SpellBasePercents().Min, rarity.SpellBasePercents().Max);
        data.scalingEffectPercent = RandomUtils.RandomRange(rarity.SpellScalingPercents().Min, rarity.SpellScalingPercents().Max);
        data.manaCostPercent = RandomUtils.RandomRange(50, 100);
        Spell.Save(stack, data);
        return LootUtils.RandomDamagedGear(stack, data.getRarity(), data.level);
    }
}

