/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.gens;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.loot.blueprints.UniqueGearBlueprint;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.loot.gens.GearLootGen;
import com.robertx22.mine_and_slash.saveclasses.gearitem.GearItemEnum;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class UniqueGearLootGen
extends BaseLootGen {
    public UniqueGearLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float BaseChance() {
        return ((Double)ModConfig.INSTANCE.DropRates.UNIQUE_DROPRATE.get()).floatValue();
    }

    @Override
    public LootType lootType() {
        return LootType.UniqueItem;
    }

    @Override
    public boolean condition() {
        return WorldUtils.dropsUniques(this.info.world);
    }

    @Override
    public ItemStack generateOne() {
        UniqueGearBlueprint gearPrint = new UniqueGearBlueprint(this.info.level, this.info.tier, true);
        ItemStack stack = UniqueGearLootGen.CreateStack(gearPrint);
        GearItemData gear = Gear.Load(stack);
        if (gear != null) {
            return LootUtils.RandomDamagedGear(stack, gear.getRarity(), gear.level);
        }
        return ItemStack.field_190927_a;
    }

    public static GearItemData CreateData(UniqueGearBlueprint blueprint) {
        return GearLootGen.CreateData(blueprint, GearItemEnum.UNIQUE);
    }

    public static ItemStack CreateStack(UniqueGearBlueprint schema) {
        GearItemData data = UniqueGearLootGen.CreateData(schema);
        if (data != null && data.getItem() != null) {
            ItemStack stack = new ItemStack((IItemProvider)data.getItem());
            Gear.Save(stack, data);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack CreateStack(GearItemData data) {
        ItemStack stack = new ItemStack((IItemProvider)data.getItem());
        Gear.Save(stack, data);
        return stack;
    }
}

