/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.gens;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.items.runes.base.BaseRuneItem;
import com.robertx22.mine_and_slash.database.items.runes.base.BaseUniqueRuneItem;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.UniqueRuneBlueprint;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RuneItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Rune;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class UniqueRuneLootGen
extends BaseLootGen {
    public UniqueRuneLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float BaseChance() {
        return ((Double)ModConfig.INSTANCE.DropRates.UNIQUE_RUNE_DROPRATE.get()).floatValue();
    }

    @Override
    public boolean condition() {
        return WorldUtils.dropsUniques(this.info.world);
    }

    @Override
    public LootType lootType() {
        return LootType.UniqueRune;
    }

    @Override
    public ItemStack generateOne() {
        UniqueRuneBlueprint runePrint = new UniqueRuneBlueprint(this.info.level, this.info.tier);
        return UniqueRuneLootGen.Create(runePrint);
    }

    public static ItemStack Create(UniqueRuneBlueprint blueprint) {
        BaseUniqueRuneItem item = blueprint.getRuneItem();
        ItemStack stack = ItemStack.field_190927_a;
        if (item != null) {
            stack = new ItemStack((IItemProvider)item);
            RuneItemData data = new RuneItemData();
            data.rarity = item.field_208075_l;
            data.name = item.GUID();
            data.level = blueprint.level;
            data.tier = item.Tier();
            data.armor = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(((BaseRuneItem)item).armorStat()));
            data.weapon = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(((BaseRuneItem)item).weaponStat()));
            data.jewerly = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(((BaseRuneItem)item).jewerlyStat()));
            Rune.Save(stack, data);
        }
        return stack;
    }
}

