/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg;

import com.robertx22.mine_and_slash.a_libraries.curios.CurioClientSetup;
import com.robertx22.mine_and_slash.a_libraries.curios.GenerateCurioDataJsons;
import com.robertx22.mine_and_slash.a_libraries.curios.RegisterCurioSlots;
import com.robertx22.mine_and_slash.a_libraries.neat_mob_overlay.HealthBarRenderer;
import com.robertx22.mine_and_slash.config.ClientContainer;
import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.config.compatible_items.ConfigItemsSerialization;
import com.robertx22.mine_and_slash.db_lists.bases.AllPreGenMapStats;
import com.robertx22.mine_and_slash.db_lists.initializers.Stats;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.mmorpg.ModelCreator;
import com.robertx22.mine_and_slash.mmorpg.RegisterEvents;
import com.robertx22.mine_and_slash.mmorpg.RegisterProfessionRecipesFromItems;
import com.robertx22.mine_and_slash.mmorpg.proxy.ClientProxy;
import com.robertx22.mine_and_slash.mmorpg.proxy.IProxy;
import com.robertx22.mine_and_slash.mmorpg.proxy.ServerProxy;
import com.robertx22.mine_and_slash.mmorpg.registers.client.ContainerGuiRegisters;
import com.robertx22.mine_and_slash.mmorpg.registers.client.KeybindsRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.client.RenderRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.client.SpecialRenderRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.CapabilityRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ConfigRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.CriteriaRegisters;
import com.robertx22.mine_and_slash.mmorpg.registers.common.OreGenRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.PacketRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.StructurePieceRegisters;
import com.robertx22.mine_and_slash.mmorpg.registers.common.WorldGenRegisters;
import com.robertx22.mine_and_slash.mmorpg.registers.server.CommandRegister;
import com.robertx22.mine_and_slash.network.sync_cap.CapTypes;
import com.robertx22.mine_and_slash.network.sync_cap.SyncCapabilityToClient;
import com.robertx22.mine_and_slash.onevent.data_gen.OnGatherData;
import com.robertx22.mine_and_slash.onevent.world.OnStartResetMaps;
import com.robertx22.mine_and_slash.tests.CountUniqueGearTypes;
import com.robertx22.mine_and_slash.tests.ValidateGuids;
import com.robertx22.mine_and_slash.uncommon.develeper.CreateLangFile;
import com.robertx22.mine_and_slash.uncommon.gui.gear_overlay.GearOverlayGUI;
import com.robertx22.mine_and_slash.uncommon.gui.player_overlays.BarsGUI;
import com.robertx22.mine_and_slash.uncommon.testing.TestManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.RandomUtils;

@Mod(value="mmorpg")
@Mod.EventBusSubscriber
public class MMORPG {
    public static boolean RUN_DEV_TOOLS = false;
    public static long MAP_WORLD_SEED = 0L;
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel Network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("mmorpg", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public static void devToolsLog(String string) {
        if (RUN_DEV_TOOLS) {
            System.out.println(string);
        }
    }

    public MMORPG() {
        System.out.println("Starting Mine and Slash");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        RegisterEvents.register();
        ConfigRegister.register();
        ConfigRegister.load();
        OnStartResetMaps.OnStartResetMaps();
        SlashRegistry.init();
        StructurePieceRegisters.reg();
        bus.addListener(this::commonSetupEvent);
        bus.addListener(this::interModProcessEvent);
        bus.addListener(this::interModEnqueue);
        bus.addListener(this::onloadComplete);
        bus.addListener(new OnGatherData()::onGatherData);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        if (MAP_WORLD_SEED == 0L) {
            MAP_WORLD_SEED = RandomUtils.nextLong();
        }
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        System.out.println("mmorpg:FMLCommonSetupEvent");
        PacketRegister.register();
        OreGenRegister.register();
        CapabilityRegister.register();
        CriteriaRegisters.register();
        WorldGenRegisters.register();
    }

    private void interModEnqueue(InterModEnqueueEvent event) {
        System.out.println("mmorpg:InterModEnqueueEvent");
        RegisterCurioSlots.register(event);
    }

    private void interModProcessEvent(InterModProcessEvent event) {
        System.out.println("mmorpg:InterModProcessEvent");
        ConfigItemsSerialization.INSTANCE.generateConfigTutorials();
        ConfigRegister.regConfigsWhichNeedMyRegistry();
        ConfigRegister.regConfigsWhichDontNeedMyRegistry();
        RegisterProfessionRecipesFromItems.register();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        SpecialRenderRegister.register(event);
        CurioClientSetup.setup(event);
        MinecraftForge.EVENT_BUS.register((Object)new BarsGUI(Minecraft.func_71410_x()));
        if (((Boolean)ClientContainer.INSTANCE.SHOW_UNMET_GEAR_REQUIREMENTS_GUI.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new GearOverlayGUI(Minecraft.func_71410_x()));
        }
        MinecraftForge.EVENT_BUS.register((Object)new HealthBarRenderer());
        KeybindsRegister.register();
        ContainerGuiRegisters.reg();
        RenderRegister.regRenders();
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        CommandRegister.Register(event.getServer());
        if (RUN_DEV_TOOLS) {
            TestManager.RunAllTests();
            CreateLangFile.create();
            GenerateCurioDataJsons.generate();
            ModelCreator.createDefaultModelsAndDirs();
            ValidateGuids.validate();
            CountUniqueGearTypes.count();
        }
    }

    @SubscribeEvent
    public static void onServerStop(FMLServerStoppedEvent event) {
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppingEvent event) {
    }

    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        if (((Boolean)ModConfig.INSTANCE.Server.DISABLE_VANILLA_HP_REGEN.get()).booleanValue()) {
            GameRules.BooleanValue value = (GameRules.BooleanValue)ServerLifecycleHooks.getCurrentServer().func_200252_aR().func_223585_a(GameRules.field_223606_i);
            value.func_223570_a(false, ServerLifecycleHooks.getCurrentServer());
        }
        Stats.allPreGenMapStatLists = new AllPreGenMapStats();
    }

    public static <MSG> void sendToTracking(MSG msg, Entity entity) {
        if (msg == null || entity == null) {
            return;
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        Network.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), msg);
        if (entity instanceof PlayerEntity) {
            MMORPG.sendToClient(msg, (ServerPlayerEntity)entity);
        }
    }

    public static <MSG> void sendToTracking(MSG msg, BlockPos pos, World world) {
        if (msg == null || world == null) {
            return;
        }
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 50.0, world.func_201675_m().func_186058_p());
        Network.send(PacketDistributor.NEAR.with(() -> point), msg);
    }

    public static <MSG> void sendToClient(MSG msg, ServerPlayerEntity player) {
        if (player != null && msg != null) {
            Network.sendTo(msg, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static <MSG> void syncMapData(ServerPlayerEntity p) {
        if (p != null) {
            MMORPG.sendToClient(new SyncCapabilityToClient(p, CapTypes.MAP_DATA), p);
        }
    }

    public static <MSG> void sendToServer(MSG msg) {
        Network.sendToServer(msg);
    }

    public void onloadComplete(FMLLoadCompleteEvent evt) {
    }
}

