/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg;

import com.robertx22.mine_and_slash.uncommon.utilityclasses.DirUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ModelCreator {
    static String DEFAULT_MODEL = "{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"mmorpg:REPLACE\"\n    }\n}";

    public static void createDefaultModelsAndDirs() {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!item.getRegistryName().func_110624_b().equals("mmorpg")) continue;
            ResourceLocation loc = item.getRegistryName();
            String path = loc.func_110623_a();
            String modelpath = DirUtils.modDir() + "\\main\\resources\\assets\\mmorpg\\models\\item\\" + path + ".json";
            String texturepath = DirUtils.modDir() + "\\main\\resources\\assets\\mmorpg\\textures\\items\\" + path + ".png";
            File model = new File(modelpath);
            File texture = new File(texturepath);
            if (!Files.exists(Paths.get(model.getParent(), new String[0]), new LinkOption[0])) {
                try {
                    Files.createDirectories(Paths.get(model.getParent(), new String[0]), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!Files.exists(Paths.get(texture.getParent(), new String[0]), new LinkOption[0])) {
                try {
                    Files.createDirectories(Paths.get(texture.getParent(), new String[0]), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Files.exists(Paths.get(model.getPath(), new String[0]), new LinkOption[0])) continue;
            try {
                Path created = Files.createFile(Paths.get(model.getPath(), new String[0]), new FileAttribute[0]);
                System.out.println("Creating file at: " + model.getPath());
                FileWriter fw = new FileWriter(created.toFile());
                fw.write(DEFAULT_MODEL.replace("REPLACE", "items/" + path));
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

