/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.registers.common;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.robertx22.mine_and_slash.config.ClientContainer;
import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.config.compatible_items.ConfigItemsSerialization;
import com.robertx22.mine_and_slash.config.dimension_configs.ConfigDimensionsSerialization;
import com.robertx22.mine_and_slash.config.mod_dmg_whitelist.ModDmgWhitelistSerialization;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfigsSerialization;
import java.nio.file.Path;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigRegister {
    public static void regConfigsWhichDontNeedMyRegistry() {
        ConfigDimensionsSerialization.INSTANCE.generateIfEmpty();
        ModDmgWhitelistSerialization.INSTANCE.generateIfEmpty();
        ModEntityConfigsSerialization.INSTANCE.generateIfEmpty();
        ConfigDimensionsSerialization.INSTANCE.load();
        ModDmgWhitelistSerialization.INSTANCE.load();
        ModEntityConfigsSerialization.INSTANCE.load();
    }

    public static void regConfigsWhichNeedMyRegistry() {
        ConfigItemsSerialization.INSTANCE.generateIfEmpty();
        ConfigItemsSerialization.INSTANCE.load();
    }

    public static void register() {
        ModLoadingContext ctx = ModLoadingContext.get();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ctx.registerConfig(ModConfig.Type.CLIENT, ClientContainer.spec));
        ctx.registerConfig(ModConfig.Type.COMMON, ModConfig.spec);
    }

    public static void load() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ConfigRegister.loadConfig(ClientContainer.spec, FMLPaths.CONFIGDIR.get().resolve("mmorpg-client.toml")));
        ConfigRegister.loadConfig(ModConfig.spec, FMLPaths.CONFIGDIR.get().resolve("mmorpg-common.toml"));
    }

    private static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }
}

